/*
 * Decompiled with CFR 0.152.
 */
package io.github.daichangya.patch;

import io.github.daichangya.model.PatchHunk;
import io.github.daichangya.model.StructuredPatch;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PatchParser {
    private static final Pattern HEADER_PATTERN = Pattern.compile("^(?:Index:|diff(?: -r \\w+)+)\\s+(.+?)\\s*$");
    private static final Pattern FILE_HEADER_PATTERN = Pattern.compile("^(---|\\+\\+\\+)\\s+(.*)\\r?$");
    private static final Pattern HUNK_HEADER_PATTERN = Pattern.compile("@@ -(\\d+)(?:,(\\d+))? \\+(\\d+)(?:,(\\d+))? @@");

    public static List<StructuredPatch> parsePatch(String uniDiff) {
        String[] lines = uniDiff.split("\n");
        ArrayList<StructuredPatch> patches = new ArrayList<StructuredPatch>();
        int i = 0;
        while (i < lines.length) {
            String line;
            String line2;
            StructuredPatch patch = new StructuredPatch();
            patches.add(patch);
            while (i < lines.length && !(line2 = lines[i]).matches("^(---|\\+\\+\\+|@@)\\s.*")) {
                Matcher headerMatcher = HEADER_PATTERN.matcher(line2);
                if (headerMatcher.matches()) {
                    patch.setIndex(headerMatcher.group(1));
                }
                ++i;
            }
            i = PatchParser.parseFileHeader(lines, i, patch, true);
            i = PatchParser.parseFileHeader(lines, i, patch, false);
            ArrayList<PatchHunk> hunks = new ArrayList<PatchHunk>();
            while (i < lines.length && !(line = lines[i]).matches("^(Index:\\s|diff\\s|---\\s|\\+\\+\\+\\s|===================================================================).*")) {
                if (line.startsWith("@@")) {
                    ParseHunkResult result = PatchParser.parseHunk(lines, i);
                    hunks.add(result.hunk);
                    i = result.nextIndex;
                    continue;
                }
                if (!line.isEmpty()) {
                    ++i;
                    continue;
                }
                ++i;
            }
            patch.setHunks(hunks);
        }
        return patches;
    }

    private static int parseFileHeader(String[] lines, int index, StructuredPatch patch, boolean isOld) {
        if (index >= lines.length) {
            return index;
        }
        Matcher matcher = FILE_HEADER_PATTERN.matcher(lines[index]);
        if (matcher.matches()) {
            String header;
            String prefix = matcher.group(1);
            String content = matcher.group(2);
            String[] parts = content.split("\t", 2);
            String fileName = parts[0].replace("\\\\", "\\");
            String string = header = parts.length > 1 ? parts[1].trim() : "";
            if (fileName.startsWith("\"") && fileName.endsWith("\"")) {
                fileName = fileName.substring(1, fileName.length() - 1);
            }
            if (prefix.equals("---")) {
                patch.setOldFileName(fileName);
                patch.setOldHeader(header.isEmpty() ? null : header);
            } else {
                patch.setNewFileName(fileName);
                patch.setNewHeader(header.isEmpty() ? null : header);
            }
            return index + 1;
        }
        return index;
    }

    private static ParseHunkResult parseHunk(String[] lines, int index) {
        String hunkHeader;
        Matcher matcher;
        if (!(matcher = HUNK_HEADER_PATTERN.matcher(hunkHeader = lines[index++])).find()) {
            throw new RuntimeException("Invalid hunk header: " + hunkHeader);
        }
        PatchHunk hunk = new PatchHunk();
        hunk.setOldStart(Integer.parseInt(matcher.group(1)));
        hunk.setOldLines(matcher.group(2) != null ? Integer.parseInt(matcher.group(2)) : 1);
        hunk.setNewStart(Integer.parseInt(matcher.group(3)));
        hunk.setNewLines(matcher.group(4) != null ? Integer.parseInt(matcher.group(4)) : 1);
        if (hunk.getOldLines() == 0) {
            hunk.setOldStart(hunk.getOldStart() + 1);
        }
        if (hunk.getNewLines() == 0) {
            hunk.setNewStart(hunk.getNewStart() + 1);
        }
        ArrayList<String> hunkLines = new ArrayList<String>();
        int addCount = 0;
        int removeCount = 0;
        while (index < lines.length && (removeCount < hunk.getOldLines() || addCount < hunk.getNewLines() || index < lines.length && lines[index].startsWith("\\"))) {
            int operation;
            String line = lines[index];
            int n = operation = line.isEmpty() && index != lines.length - 1 ? 32 : line.charAt(0);
            if (operation != 43 && operation != 45 && operation != 32 && operation != 92) break;
            hunkLines.add(line);
            if (operation == 43) {
                ++addCount;
            } else if (operation == 45) {
                ++removeCount;
            } else if (operation == 32) {
                ++addCount;
                ++removeCount;
            }
            ++index;
        }
        hunk.setLines(hunkLines);
        return new ParseHunkResult(hunk, index);
    }

    private static class ParseHunkResult {
        PatchHunk hunk;
        int nextIndex;

        ParseHunkResult(PatchHunk hunk, int nextIndex) {
            this.hunk = hunk;
            this.nextIndex = nextIndex;
        }
    }
}

