/*
 * Decompiled with CFR 0.152.
 */
package io.github.daichangya.patch;

import io.github.daichangya.model.PatchHunk;
import io.github.daichangya.model.StructuredPatch;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public class PatchReverser {
    public static StructuredPatch reversePatch(StructuredPatch patch) {
        StructuredPatch reversed = new StructuredPatch();
        reversed.setOldFileName(patch.getNewFileName());
        reversed.setNewFileName(patch.getOldFileName());
        reversed.setOldHeader(patch.getNewHeader());
        reversed.setNewHeader(patch.getOldHeader());
        reversed.setIndex(patch.getIndex());
        ArrayList<PatchHunk> reversedHunks = new ArrayList<PatchHunk>();
        for (PatchHunk hunk : patch.getHunks()) {
            PatchHunk reversedHunk = new PatchHunk();
            reversedHunk.setOldLines(hunk.getNewLines());
            reversedHunk.setOldStart(hunk.getNewStart());
            reversedHunk.setNewLines(hunk.getOldLines());
            reversedHunk.setNewStart(hunk.getOldStart());
            List<String> reversedLines = hunk.getLines().stream().map(line -> {
                if (line.startsWith("-")) {
                    return "+" + line.substring(1);
                }
                if (line.startsWith("+")) {
                    return "-" + line.substring(1);
                }
                return line;
            }).collect(Collectors.toList());
            reversedHunk.setLines(reversedLines);
            reversedHunks.add(reversedHunk);
        }
        reversed.setHunks(reversedHunks);
        return reversed;
    }

    public static List<StructuredPatch> reversePatch(List<StructuredPatch> patches) {
        List<StructuredPatch> reversed = patches.stream().map(PatchReverser::reversePatch).collect(Collectors.toList());
        Collections.reverse(reversed);
        return reversed;
    }
}

