/*
 * Decompiled with CFR 0.152.
 */
package io.github.daichangya.util;

import java.util.Iterator;
import java.util.NoSuchElementException;

public class DistanceIterator
implements Iterator<Integer> {
    private final int start;
    private final int minLine;
    private final int maxLine;
    private boolean wantForward = true;
    private boolean backwardExhausted = false;
    private boolean forwardExhausted = false;
    private int localOffset = 1;
    private Integer next = null;

    public DistanceIterator(int start, int minLine, int maxLine) {
        this.start = start;
        this.minLine = minLine;
        this.maxLine = maxLine;
        this.computeNext();
    }

    @Override
    public boolean hasNext() {
        return this.next != null;
    }

    @Override
    public Integer next() {
        if (this.next == null) {
            throw new NoSuchElementException();
        }
        Integer result = this.next;
        this.computeNext();
        return result;
    }

    private void computeNext() {
        this.next = this.iterator();
    }

    private Integer iterator() {
        if (this.wantForward && !this.forwardExhausted) {
            if (this.backwardExhausted) {
                ++this.localOffset;
            } else {
                this.wantForward = false;
            }
            if (this.start + this.localOffset <= this.maxLine) {
                return this.start + this.localOffset;
            }
            this.forwardExhausted = true;
        }
        if (!this.backwardExhausted) {
            if (!this.forwardExhausted) {
                this.wantForward = true;
            }
            if (this.minLine <= this.start - this.localOffset) {
                return this.start - this.localOffset++;
            }
            this.backwardExhausted = true;
            return this.iterator();
        }
        return null;
    }

    public static DistanceIterator create(int start, int minLine, int maxLine) {
        return new DistanceIterator(start, minLine, maxLine);
    }
}

