/*
 * Decompiled with CFR 0.152.
 */
package io.github.daichangya.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StringUtil {
    private static final Pattern WHITESPACE_PATTERN = Pattern.compile("\\s");
    private static final Pattern LEADING_WS_PATTERN = Pattern.compile("^\\s*");

    public static String longestCommonPrefix(String str1, String str2) {
        int i;
        int minLen = Math.min(str1.length(), str2.length());
        for (i = 0; i < minLen; ++i) {
            if (str1.charAt(i) == str2.charAt(i)) continue;
            return str1.substring(0, i);
        }
        return str1.substring(0, i);
    }

    public static String longestCommonSuffix(String str1, String str2) {
        int i;
        if (str1 == null || str2 == null || str1.isEmpty() || str2.isEmpty() || str1.charAt(str1.length() - 1) != str2.charAt(str2.length() - 1)) {
            return "";
        }
        int minLen = Math.min(str1.length(), str2.length());
        for (i = 0; i < minLen; ++i) {
            if (str1.charAt(str1.length() - (i + 1)) == str2.charAt(str2.length() - (i + 1))) continue;
            return str1.substring(str1.length() - i);
        }
        return str1.substring(str1.length() - i);
    }

    public static String replacePrefix(String string, String oldPrefix, String newPrefix) {
        if (!string.startsWith(oldPrefix)) {
            throw new IllegalArgumentException(String.format("string \"%s\" doesn't start with prefix \"%s\"; this is a bug", string, oldPrefix));
        }
        return newPrefix + string.substring(oldPrefix.length());
    }

    public static String replaceSuffix(String string, String oldSuffix, String newSuffix) {
        if (oldSuffix.isEmpty()) {
            return string + newSuffix;
        }
        if (!string.endsWith(oldSuffix)) {
            throw new IllegalArgumentException(String.format("string \"%s\" doesn't end with suffix \"%s\"; this is a bug", string, oldSuffix));
        }
        return string.substring(0, string.length() - oldSuffix.length()) + newSuffix;
    }

    public static String removePrefix(String string, String oldPrefix) {
        return StringUtil.replacePrefix(string, oldPrefix, "");
    }

    public static String removeSuffix(String string, String oldSuffix) {
        return StringUtil.replaceSuffix(string, oldSuffix, "");
    }

    public static String maximumOverlap(String string1, String string2) {
        return string2.substring(0, StringUtil.overlapCount(string1, string2));
    }

    private static int overlapCount(String a, String b) {
        int startA = 0;
        if (a.length() > b.length()) {
            startA = a.length() - b.length();
        }
        int endB = b.length();
        if (a.length() < b.length()) {
            endB = a.length();
        }
        int[] map = new int[endB];
        int k = 0;
        map[0] = 0;
        for (int j = 1; j < endB; ++j) {
            map[j] = b.charAt(j) == b.charAt(k) ? map[k] : k;
            while (k > 0 && b.charAt(j) != b.charAt(k)) {
                k = map[k];
            }
            if (b.charAt(j) != b.charAt(k)) continue;
            ++k;
        }
        k = 0;
        for (int i = startA; i < a.length(); ++i) {
            while (k > 0 && a.charAt(i) != b.charAt(k)) {
                k = map[k];
            }
            if (a.charAt(i) != b.charAt(k)) continue;
            ++k;
        }
        return k;
    }

    public static boolean hasOnlyWinLineEndings(String string) {
        return string.contains("\r\n") && !string.startsWith("\n") && !string.matches("[^\r]\n");
    }

    public static boolean hasOnlyUnixLineEndings(String string) {
        return !string.contains("\r\n") && string.contains("\n");
    }

    public static String trailingWs(String string) {
        int i;
        for (i = string.length() - 1; i >= 0 && WHITESPACE_PATTERN.matcher(String.valueOf(string.charAt(i))).matches(); --i) {
        }
        return string.substring(i + 1);
    }

    public static String leadingWs(String string) {
        Matcher matcher = LEADING_WS_PATTERN.matcher(string);
        return matcher.find() ? matcher.group() : "";
    }

    public static int[] toCodePoints(String str) {
        return str.codePoints().toArray();
    }

    public static String fromCodePoints(int[] codePoints) {
        return new String(codePoints, 0, codePoints.length);
    }
}

