/*
 * Decompiled with CFR 0.152.
 */
package io.github.deppan;

import io.github.deppan.BroadcastOptions;
import io.github.deppan.PacketType;
import io.github.deppan.RedisClient;
import io.github.deppan.RequestType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class BroadcastOperator {
    private final Set<String> reserved = Set.of(new String[]{"connect", "connect_error", "disconnect", "disconnecting", "newListener", "removeListener"});
    private final RedisClient redisClient;
    private final BroadcastOptions broadcastOptions;
    private Set<String> rooms = new HashSet<String>();
    private Set<String> exceptRooms = new HashSet<String>();
    private Map<String, Object> flags = new HashMap<String, Object>();

    public BroadcastOperator(RedisClient redisClient, BroadcastOptions broadcastOptions, Set<String> rooms, Set<String> exceptRooms, Map<String, Object> flags) {
        this.redisClient = redisClient;
        this.broadcastOptions = broadcastOptions;
        if (rooms != null) {
            this.rooms = rooms;
        }
        if (exceptRooms != null) {
            this.exceptRooms = exceptRooms;
        }
        if (flags != null) {
            this.flags = flags;
        }
    }

    public BroadcastOperator(RedisClient redisClient, BroadcastOptions broadcastOptions) {
        this.redisClient = redisClient;
        this.broadcastOptions = broadcastOptions;
    }

    public BroadcastOperator to(String ... room) {
        HashSet<String> rooms = new HashSet<String>(this.rooms);
        Collections.addAll(rooms, room);
        return new BroadcastOperator(this.redisClient, this.broadcastOptions, rooms, this.exceptRooms, this.flags);
    }

    public BroadcastOperator in(String ... room) {
        return this.to(room);
    }

    public BroadcastOperator except(String ... room) {
        HashSet<String> exceptRooms = new HashSet<String>(this.exceptRooms);
        Collections.addAll(exceptRooms, room);
        return new BroadcastOperator(this.redisClient, this.broadcastOptions, this.rooms, exceptRooms, this.flags);
    }

    public BroadcastOperator compress(boolean compress) {
        HashMap<String, Object> flags = new HashMap<String, Object>(this.flags);
        flags.put("compress", compress);
        return new BroadcastOperator(this.redisClient, this.broadcastOptions, this.rooms, this.exceptRooms, flags);
    }

    public BroadcastOperator volatileFunc() {
        HashMap<String, Object> flags = new HashMap<String, Object>(this.flags);
        flags.put("volatile", "true");
        return new BroadcastOperator(this.redisClient, this.broadcastOptions, this.rooms, this.exceptRooms, flags);
    }

    public boolean emit(String event, Object ... args) {
        if (this.reserved.contains(event)) {
            throw new RuntimeException("\"" + event + "\" is a reserved event name");
        }
        ArrayList<String> data = new ArrayList<String>();
        data.add(event);
        Collections.addAll(data, args);
        Map<String, String> packet = Map.of("type", PacketType.EVENT.value, "data", data, "nsp", this.broadcastOptions.nsp);
        Map<String, ArrayList<String>> ops = Map.of("rooms", new ArrayList<String>(this.rooms), "flags", this.flags, "except", new ArrayList<String>(this.exceptRooms));
        Object channel = this.broadcastOptions.broadcastChannel;
        if (this.rooms.size() == 1) {
            channel = (String)channel + this.rooms.stream().collect(Collectors.joining("#", "", "#"));
        }
        try {
            byte[] msg = this.broadcastOptions.parser.encode(Arrays.asList("emitter", packet, ops));
            this.redisClient.publish((String)channel, msg);
            return true;
        }
        catch (Exception exception) {
            this.broadcastOptions.logger.debug("emit: {}", (Object)exception.toString());
            return false;
        }
    }

    public void socketsJoin(String ... room) {
        Map<String, Object> map = Map.of("type", RequestType.REMOTE_JOIN.value, "opts", Map.of("rooms", new ArrayList<String>(this.rooms), "except", new ArrayList<String>(this.exceptRooms)), "rooms", room.length == 1 ? room[0] : Arrays.asList(room));
        try {
            byte[] request = this.broadcastOptions.parser.encode(map);
            this.redisClient.publish(this.broadcastOptions.requestChannel, request);
        }
        catch (Exception exception) {
            this.broadcastOptions.logger.debug("socketsJoin: {}", (Object)exception.toString());
        }
    }

    public void socketsLeave(String ... room) {
        Map<String, List<String>> map = Map.of("type", RequestType.REMOTE_LEAVE.value, "opts", Map.of("rooms", new ArrayList<String>(this.rooms), "except", new ArrayList<String>(this.exceptRooms)), "rooms", Arrays.asList(room));
        try {
            byte[] request = this.broadcastOptions.parser.encode(map);
            this.redisClient.publish(this.broadcastOptions.requestChannel, request);
        }
        catch (Exception exception) {
            this.broadcastOptions.logger.debug("socketsLeave: {}", (Object)exception.toString());
        }
    }

    public void disconnectSockets(boolean close) {
        Map<String, Boolean> map = Map.of("type", RequestType.REMOTE_DISCONNECT.value, "opts", Map.of("rooms", new ArrayList<String>(this.rooms), "except", new ArrayList<String>(this.exceptRooms)), "close", close);
        try {
            byte[] request = this.broadcastOptions.parser.encode(map);
            this.redisClient.publish(this.broadcastOptions.requestChannel, request);
        }
        catch (Exception exception) {
            this.broadcastOptions.logger.debug("disconnectSockets: {}", (Object)exception.toString());
        }
    }
}

