/*
 * Decompiled with CFR 0.152.
 */
package io.github.deppan;

import io.github.deppan.BroadcastOperator;
import io.github.deppan.BroadcastOptions;
import io.github.deppan.EmitterOptions;
import io.github.deppan.MsgPackParser;
import io.github.deppan.RedisClient;
import io.github.deppan.RequestType;
import java.util.Map;

public class Emitter {
    public static final String UID = "emitter";
    private final EmitterOptions opts;
    private final BroadcastOptions broadcastOptions;
    private final RedisClient redisClient;

    public Emitter(RedisClient redisClient, EmitterOptions opts, String nsp) {
        if (nsp == null) {
            nsp = "/";
        }
        this.redisClient = redisClient;
        this.opts = new EmitterOptions("socket.io", new MsgPackParser());
        if (opts != null) {
            if (opts.key != null) {
                this.opts.key = opts.key;
            }
            if (opts.parser != null) {
                this.opts.parser = opts.parser;
            }
        }
        this.broadcastOptions = new BroadcastOptions(nsp, this.opts.key + "#" + nsp + "#", this.opts.key + "-request#" + nsp + "#", this.opts.parser);
    }

    public Emitter of(String nsp) {
        return new Emitter(this.redisClient, this.opts, (nsp.charAt(0) != '/' ? "/" : "") + nsp);
    }

    public boolean emit(String event, Object ... args) {
        return new BroadcastOperator(this.redisClient, this.broadcastOptions).emit(event, args);
    }

    public BroadcastOperator to(String ... room) {
        return new BroadcastOperator(this.redisClient, this.broadcastOptions).to(room);
    }

    public BroadcastOperator in(String ... room) {
        return new BroadcastOperator(this.redisClient, this.broadcastOptions).in(room);
    }

    public BroadcastOperator except(String ... room) {
        return new BroadcastOperator(this.redisClient, this.broadcastOptions).except(room);
    }

    public BroadcastOperator volatileFunc() {
        return new BroadcastOperator(this.redisClient, this.broadcastOptions).volatileFunc();
    }

    public BroadcastOperator compress(boolean compress) {
        return new BroadcastOperator(this.redisClient, this.broadcastOptions).compress(compress);
    }

    public void socketsJoin(String ... room) {
        new BroadcastOperator(this.redisClient, this.broadcastOptions).socketsJoin(room);
    }

    public void socketsLeave(String ... room) {
        new BroadcastOperator(this.redisClient, this.broadcastOptions).socketsLeave(room);
    }

    public void disconnectSockets(boolean close) {
        new BroadcastOperator(this.redisClient, this.broadcastOptions).disconnectSockets(close);
    }

    public void serverSideEmit(Object ... args) {
        Map<String, Object[]> map = Map.of("uid", UID, "type", RequestType.SERVER_SIDE_EMIT.value, "data", args);
        try {
            byte[] request = this.broadcastOptions.parser.encode(map);
            this.redisClient.publish(this.broadcastOptions.requestChannel, request);
        }
        catch (Exception exception) {
            this.broadcastOptions.logger.debug("serverSideEmit: {}", (Object)exception.toString());
        }
    }
}

