/*
 * Decompiled with CFR 0.152.
 */
package com.devintest.api.core;

import com.devintest.api.core.ObjectMappers;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import okhttp3.HttpUrl;
import okhttp3.MultipartBody;

public class QueryStringMapper {
    private static final ObjectMapper MAPPER = ObjectMappers.JSON_MAPPER;

    public static void addQueryParameter(HttpUrl.Builder httpUrl, String key, Object value, boolean arraysAsRepeats) {
        List<Map.Entry<String, JsonNode>> flat;
        JsonNode valueNode = MAPPER.valueToTree(value);
        if (valueNode.isObject()) {
            flat = QueryStringMapper.flattenObject((ObjectNode)valueNode, arraysAsRepeats);
        } else if (valueNode.isArray()) {
            flat = QueryStringMapper.flattenArray((ArrayNode)valueNode, "", arraysAsRepeats);
        } else {
            if (valueNode.isTextual()) {
                httpUrl.addQueryParameter(key, valueNode.textValue());
            } else {
                httpUrl.addQueryParameter(key, valueNode.toString());
            }
            return;
        }
        for (Map.Entry<String, JsonNode> field : flat) {
            if (field.getValue().isTextual()) {
                httpUrl.addQueryParameter(key + field.getKey(), field.getValue().textValue());
                continue;
            }
            httpUrl.addQueryParameter(key + field.getKey(), field.getValue().toString());
        }
    }

    public static void addFormDataPart(MultipartBody.Builder multipartBody, String key, Object value, boolean arraysAsRepeats) {
        List<Map.Entry<String, JsonNode>> flat;
        JsonNode valueNode = MAPPER.valueToTree(value);
        if (valueNode.isObject()) {
            flat = QueryStringMapper.flattenObject((ObjectNode)valueNode, arraysAsRepeats);
        } else if (valueNode.isArray()) {
            flat = QueryStringMapper.flattenArray((ArrayNode)valueNode, "", arraysAsRepeats);
        } else {
            if (valueNode.isTextual()) {
                multipartBody.addFormDataPart(key, valueNode.textValue());
            } else {
                multipartBody.addFormDataPart(key, valueNode.toString());
            }
            return;
        }
        for (Map.Entry<String, JsonNode> field : flat) {
            if (field.getValue().isTextual()) {
                multipartBody.addFormDataPart(key + field.getKey(), field.getValue().textValue());
                continue;
            }
            multipartBody.addFormDataPart(key + field.getKey(), field.getValue().toString());
        }
    }

    public static List<Map.Entry<String, JsonNode>> flattenObject(ObjectNode object, boolean arraysAsRepeats) {
        ArrayList<Map.Entry<String, JsonNode>> flat = new ArrayList<Map.Entry<String, JsonNode>>();
        Iterator fields = object.fields();
        while (fields.hasNext()) {
            List<Map.Entry<String, JsonNode>> flatField;
            Map.Entry field = (Map.Entry)fields.next();
            String key = "[" + (String)field.getKey() + "]";
            if (((JsonNode)field.getValue()).isObject()) {
                flatField = QueryStringMapper.flattenObject((ObjectNode)field.getValue(), arraysAsRepeats);
                QueryStringMapper.addAll(flat, flatField, key);
                continue;
            }
            if (((JsonNode)field.getValue()).isArray()) {
                flatField = QueryStringMapper.flattenArray((ArrayNode)field.getValue(), key, arraysAsRepeats);
                QueryStringMapper.addAll(flat, flatField, "");
                continue;
            }
            flat.add(new AbstractMap.SimpleEntry<String, JsonNode>(key, (JsonNode)field.getValue()));
        }
        return flat;
    }

    private static List<Map.Entry<String, JsonNode>> flattenArray(ArrayNode array, String key, boolean arraysAsRepeats) {
        ArrayList<Map.Entry<String, JsonNode>> flat = new ArrayList<Map.Entry<String, JsonNode>>();
        Iterator elements = array.elements();
        int index = 0;
        while (elements.hasNext()) {
            List<Map.Entry<String, JsonNode>> flatField;
            JsonNode element = (JsonNode)elements.next();
            String indexKey = key + "[" + index + "]";
            if (arraysAsRepeats) {
                indexKey = key;
            }
            if (element.isObject()) {
                flatField = QueryStringMapper.flattenObject((ObjectNode)element, arraysAsRepeats);
                QueryStringMapper.addAll(flat, flatField, indexKey);
            } else if (element.isArray()) {
                flatField = QueryStringMapper.flattenArray((ArrayNode)element, "", arraysAsRepeats);
                QueryStringMapper.addAll(flat, flatField, indexKey);
            } else {
                flat.add(new AbstractMap.SimpleEntry<String, JsonNode>(indexKey, element));
            }
            ++index;
        }
        return flat;
    }

    private static void addAll(List<Map.Entry<String, JsonNode>> target, List<Map.Entry<String, JsonNode>> source, String prefix) {
        for (Map.Entry<String, JsonNode> entry : source) {
            AbstractMap.SimpleEntry<String, JsonNode> entryToAdd = new AbstractMap.SimpleEntry<String, JsonNode>(prefix + entry.getKey(), entry.getValue());
            target.add(entryToAdd);
        }
    }
}

