/*
 * Decompiled with CFR 0.152.
 */
package io.github.devlibx.easy.testing.mysql.base;

import com.google.inject.AbstractModule;
import com.google.inject.Guice;
import com.google.inject.Injector;
import io.gitbub.devlibx.easy.helper.ApplicationContext;
import io.gitbub.devlibx.easy.helper.metrics.IMetrics;
import io.github.devlibx.easy.testing.mysql.base.PersistenceTestState;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import org.junit.jupiter.api.AfterEach;

public abstract class PersistenceBaseTestCase {
    protected PersistenceTestState.PersistenceTestContext persistenceTestContext;
    protected Injector injector;

    public void setupTest() {
        this.persistenceTestContext = PersistenceTestState.instance().getContext();
        this.persistenceTestContext.setLongs(new HashMap<String, Long>());
        this.persistenceTestContext.setUuids(new HashMap<String, UUID>());
        this.persistenceTestContext.setStrings(new HashMap<String, String>());
        this.setupLogging();
        this.setupPersistenceTestContext();
        this.setupGuice();
        this.setupDatabase();
        this.bootstrapDatabase();
    }

    protected void setupPersistenceTestContext() {
    }

    private void setupLogging() {
    }

    private void setupGuice() {
        this.injector = Guice.createInjector(this.getModuleList());
        ApplicationContext.setInjector((Injector)this.injector);
    }

    protected void setupDatabase() {
    }

    protected void bootstrapDatabase() {
    }

    protected List<AbstractModule> getModuleList() {
        ArrayList<AbstractModule> modules = new ArrayList<AbstractModule>();
        modules.add(new AbstractModule(){

            protected void configure() {
                this.bind(IMetrics.class).to(IMetrics.NoOpMetrics.class);
            }
        });
        return modules;
    }

    public String getOrCreateString(String key) {
        if (!this.persistenceTestContext.getStrings().containsKey(key)) {
            this.persistenceTestContext.getStrings().put(key, UUID.randomUUID().toString());
        }
        return this.persistenceTestContext.getStrings().get(key);
    }

    public String getOrCreateString(String key, String prefix) {
        if (!this.persistenceTestContext.getStrings().containsKey(key)) {
            this.persistenceTestContext.getStrings().put(key, prefix + UUID.randomUUID().toString());
        }
        return this.persistenceTestContext.getStrings().get(key);
    }

    public Long getOrCreateLong(String key) {
        if (!this.persistenceTestContext.getLongs().containsKey(key)) {
            Random random = new Random();
            this.persistenceTestContext.getLongs().put(key, random.nextLong());
        }
        return this.persistenceTestContext.getLongs().get(key);
    }

    public UUID getOrCreateUUID(String key) {
        if (!this.persistenceTestContext.getUuids().containsKey(key)) {
            this.persistenceTestContext.getUuids().put(key, UUID.randomUUID());
        }
        return this.persistenceTestContext.getUuids().get(key);
    }

    @AfterEach
    public void tearDown() throws Exception {
    }
}

