/*
 * Decompiled with CFR 0.152.
 */
package io.github.devsecops.engine.core;

import io.github.devsecops.engine.core.Log;
import io.github.devsecops.engine.core.contract.Executor;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.file.Files;
import java.util.Map;
import java.util.stream.Stream;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class BashShellExecutor
extends Executor {
    @Autowired
    private Log log;
    private File logFile = new File("engine-plugin.log");

    @Override
    public String execute(String cmd, Map<String, String> params) throws IOException, InterruptedException {
        Process process;
        int status;
        this.log.info(String.format("Executing command : %s", cmd));
        ProcessBuilder processBuilder = new ProcessBuilder("bash", "-c", cmd).redirectOutput(this.logFile).redirectErrorStream(true);
        if (!CollectionUtils.isEmpty(params)) {
            processBuilder.environment().putAll(params);
        }
        if ((status = (process = processBuilder.start()).waitFor()) != 0) {
            this.logError(cmd, status);
            throw new InterruptedException();
        }
        this.log.info(String.format("Command: %s >>>> OK", cmd));
        return this.getLogsMessages(cmd);
    }

    private String getLogsMessages(String cmd) throws IOException {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter((Writer)stringWriter, true);
        Stream<String> lines = Files.readAllLines(this.logFile.toPath()).stream().map(String::toString);
        lines.forEach(printWriter::println);
        return stringWriter.toString();
    }

    private void logError(String cmd, int status) throws IOException {
        this.log.error(String.format("Command: %s ended with status: %s", cmd, status));
        this.log.error(this.getLogsMessages(cmd));
    }
}

