/*
 * Decompiled with CFR 0.152.
 */
package io.github.devsecops.engine.domain.artifact.instructions;

import io.github.devsecops.engine.core.contract.Instruction;

public class JavaPathInstruction
implements Instruction {
    private static final String CMD = "export JAVA_HOME=%s";
    private final String javaHome;

    @Override
    public String getCmd() {
        return String.format(CMD, this.javaHome);
    }

    public static JavaPathInstructionBuilder builder() {
        return new JavaPathInstructionBuilder();
    }

    public JavaPathInstruction(String javaHome) {
        this.javaHome = javaHome;
    }

    public static class JavaPathInstructionBuilder {
        private String javaHome;

        JavaPathInstructionBuilder() {
        }

        public JavaPathInstructionBuilder javaHome(String javaHome) {
            this.javaHome = javaHome;
            return this;
        }

        public JavaPathInstruction build() {
            return new JavaPathInstruction(this.javaHome);
        }

        public String toString() {
            return "JavaPathInstruction.JavaPathInstructionBuilder(javaHome=" + this.javaHome + ")";
        }
    }
}

