/*
 * Decompiled with CFR 0.152.
 */
package io.github.devsecops.engine.domain.docker.instructions;

import io.github.devsecops.engine.core.contract.Instruction;

public class DockerBuildImageInstruction
implements Instruction {
    private static final String CMD = "docker build -t %s-%s -f ./ci/build/Dockerfile . || exit 1";
    private final String imageUrl;
    private final String type;

    @Override
    public String getCmd() {
        return String.format(CMD, this.imageUrl, this.type);
    }

    public static DockerBuildImageInstructionBuilder builder() {
        return new DockerBuildImageInstructionBuilder();
    }

    public DockerBuildImageInstruction(String imageUrl, String type) {
        this.imageUrl = imageUrl;
        this.type = type;
    }

    public static class DockerBuildImageInstructionBuilder {
        private String imageUrl;
        private String type;

        DockerBuildImageInstructionBuilder() {
        }

        public DockerBuildImageInstructionBuilder imageUrl(String imageUrl) {
            this.imageUrl = imageUrl;
            return this;
        }

        public DockerBuildImageInstructionBuilder type(String type) {
            this.type = type;
            return this;
        }

        public DockerBuildImageInstruction build() {
            return new DockerBuildImageInstruction(this.imageUrl, this.type);
        }

        public String toString() {
            return "DockerBuildImageInstruction.DockerBuildImageInstructionBuilder(imageUrl=" + this.imageUrl + ", type=" + this.type + ")";
        }
    }
}

