/*
 * Decompiled with CFR 0.152.
 */
package io.github.devsecops.engine.domain.docker.instructions;

import io.github.devsecops.engine.core.contract.Instruction;

public class DockerPushImageInstruction
implements Instruction {
    private static final String CMD = "docker push %s%s || exit 1";
    private final String imageUrl;
    private final String type;

    @Override
    public String getCmd() {
        return String.format(CMD, this.imageUrl, this.type);
    }

    public static DockerPushImageInstructionBuilder builder() {
        return new DockerPushImageInstructionBuilder();
    }

    public DockerPushImageInstruction(String imageUrl, String type) {
        this.imageUrl = imageUrl;
        this.type = type;
    }

    public static class DockerPushImageInstructionBuilder {
        private String imageUrl;
        private String type;

        DockerPushImageInstructionBuilder() {
        }

        public DockerPushImageInstructionBuilder imageUrl(String imageUrl) {
            this.imageUrl = imageUrl;
            return this;
        }

        public DockerPushImageInstructionBuilder type(String type) {
            this.type = type;
            return this;
        }

        public DockerPushImageInstruction build() {
            return new DockerPushImageInstruction(this.imageUrl, this.type);
        }

        public String toString() {
            return "DockerPushImageInstruction.DockerPushImageInstructionBuilder(imageUrl=" + this.imageUrl + ", type=" + this.type + ")";
        }
    }
}

