/*
 * Decompiled with CFR 0.152.
 */
package io.github.devsecops.engine.domain.genconfig.commands;

import io.github.devsecops.engine.core.contract.Command;
import io.github.devsecops.engine.core.model.Environment;
import io.github.devsecops.engine.domain.resolver.utils.TokenReplacement;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractConfigCommand
implements Command {
    private Environment env;
    @Autowired
    private TokenReplacement tokenReplacement;

    public abstract String getTemplatePath();

    public abstract String getOutputPath();

    @Override
    public void execute() throws Exception {
        List<String> lines = Files.readAllLines(Paths.get(this.getTemplatePath(), new String[0]));
        List replacedLines = lines.stream().map(line -> this.tokenReplacement.replace((String)line)).collect(Collectors.toList());
        Files.write(Paths.get(this.getOutputPath(), new String[0]), replacedLines, new OpenOption[0]);
    }

    @Override
    public void rollback() throws Exception {
        throw new UnsupportedOperationException("Nothing to rollback when generating a config file");
    }

    public Environment getEnv() {
        return this.env;
    }

    public void setEnv(Environment env) {
        this.env = env;
    }
}

