/*
 * Decompiled with CFR 0.152.
 */
package io.github.devsecops.engine.domain.git.instructions;

import io.github.devsecops.engine.core.contract.Instruction;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;

public class GitInitConfigInstruction
implements Instruction {
    private static final String CMD = "git config --global user.email \"mustapha.senhaji.87@gmail.com\" && git config --global user.name \"Jenkins Automated Agent\" && git config http.sslVerify false && git remote set-url origin \"%s\" && git config remote.origin.fetch '+refs/heads/*:refs/remotes/origin/*' && git fetch --all";
    private String username;
    private String password;
    private String gitUrlTemplate;

    @Override
    public String getCmd() {
        String gitUrl = null;
        try {
            gitUrl = String.format(this.gitUrlTemplate, this.username, URLEncoder.encode(this.password, StandardCharsets.UTF_8.toString()));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Couldn't encode password prior pushing to git");
        }
        return String.format(CMD, gitUrl);
    }

    public static GitInitConfigInstructionBuilder builder() {
        return new GitInitConfigInstructionBuilder();
    }

    public GitInitConfigInstruction(String username, String password, String gitUrlTemplate) {
        this.username = username;
        this.password = password;
        this.gitUrlTemplate = gitUrlTemplate;
    }

    public static class GitInitConfigInstructionBuilder {
        private String username;
        private String password;
        private String gitUrlTemplate;

        GitInitConfigInstructionBuilder() {
        }

        public GitInitConfigInstructionBuilder username(String username) {
            this.username = username;
            return this;
        }

        public GitInitConfigInstructionBuilder password(String password) {
            this.password = password;
            return this;
        }

        public GitInitConfigInstructionBuilder gitUrlTemplate(String gitUrlTemplate) {
            this.gitUrlTemplate = gitUrlTemplate;
            return this;
        }

        public GitInitConfigInstruction build() {
            return new GitInitConfigInstruction(this.username, this.password, this.gitUrlTemplate);
        }

        public String toString() {
            return "GitInitConfigInstruction.GitInitConfigInstructionBuilder(username=" + this.username + ", password=" + this.password + ", gitUrlTemplate=" + this.gitUrlTemplate + ")";
        }
    }
}

