/*
 * Decompiled with CFR 0.152.
 */
package io.github.devsecops.engine.domain.pom.commands;

import io.github.devsecops.engine.core.contract.Command;
import io.github.devsecops.engine.domain.pom.model.Pom;
import io.github.devsecops.engine.domain.pom.model.SemanticVersion;
import org.springframework.stereotype.Component;

@Component
public class PomValidatorCommand
implements Command {
    @Override
    public void execute() throws Exception {
        Pom pom = Pom.getINSTANCE();
        boolean isValid = pom.getSemanticVersion().map(SemanticVersion::isSnapshot).orElse(false);
        if (!isValid) {
            throw new Exception("Not valid pom, you should have SNAPSHOT as qualifier in the version");
        }
        boolean bl = isValid = pom.snapshotsCount() <= 1L;
        if (!isValid) {
            throw new Exception("Pom shouldn't not have more than 1 SNAPSHOT versions among plugins and dependencies. Only work with released artifacts");
        }
    }

    @Override
    public void rollback() throws Exception {
        throw new UnsupportedOperationException("No rollback is specified for artifact commands");
    }
}

