/*
 * Decompiled with CFR 0.152.
 */
package io.github.devsecops.engine.domain.resolver.strategy;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import io.github.devsecops.engine.core.Log;
import io.github.devsecops.engine.domain.resolver.strategy.ResolverStrategy;
import org.apache.commons.lang3.StringUtils;

public class Resolver {
    private final ResolverStrategy propertiesResolver;
    private final ResolverStrategy environmentResolver;
    private final ResolverStrategy vaultStrategyResolver;
    private final Log logger;
    private LoadingCache<String, String> values = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<String, String>(){

        public String load(String propertyName) throws Exception {
            return Resolver.this.timeConsumingResolution(propertyName);
        }
    });

    public String resolve(String propertyName) {
        try {
            return (String)this.values.get((Object)propertyName);
        }
        catch (Exception e) {
            this.logger.warn(String.format(">> Property: %s was not resolved, return the key name instead", propertyName));
            return propertyName;
        }
    }

    private String timeConsumingResolution(String propertyName) {
        String propertyValue = propertyName;
        this.logger.info(">> First time resolving property " + propertyName);
        try {
            propertyValue = this.propertiesResolver.resolve(propertyName).orElseGet(() -> this.environmentResolver.resolve(propertyName).get());
            if (this.isVaultProperty(propertyValue)) {
                return this.vaultStrategyResolver.resolve(propertyValue).orElse(propertyValue);
            }
        }
        catch (Exception e) {
            this.logger.error(String.format(">> Property: %s was not resolved, return the key name instead", propertyName));
            throw e;
        }
        return propertyValue;
    }

    private boolean isVaultProperty(String property) {
        return StringUtils.isNotBlank((CharSequence)property) && property.startsWith("#[vault:");
    }

    public Resolver(ResolverStrategy propertiesResolver, ResolverStrategy environmentResolver, ResolverStrategy vaultStrategyResolver, Log logger) {
        this.propertiesResolver = propertiesResolver;
        this.environmentResolver = environmentResolver;
        this.vaultStrategyResolver = vaultStrategyResolver;
        this.logger = logger;
    }
}

