/*
 * Decompiled with CFR 0.152.
 */
package io.github.devsecops.engine.domain.sonar.api;

import com.google.common.collect.ImmutableMap;
import io.github.devsecops.engine.domain.sonar.model.Metric;
import io.github.devsecops.engine.domain.sonar.utils.SonarMeasureMapper;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.sonar.wsclient.SonarClient;

public class SonarMeasuresApi {
    private static final String METRIC_REST_ENDPOINT = "api/measures/component";
    private final SonarClient sonarClient;
    private final SonarMeasureMapper mapper;

    public SonarMeasuresApi(SonarClient sonarClient) {
        this.sonarClient = sonarClient;
        this.mapper = new SonarMeasureMapper();
    }

    public Map<Metric, Integer> calculate(String component) {
        List metrics = Arrays.asList(Metric.values()).stream().map(Metric::getName).collect(Collectors.toList());
        ImmutableMap params = ImmutableMap.of((Object)"component", (Object)component, (Object)"metricKeys", (Object)String.join((CharSequence)",", metrics));
        String response = this.sonarClient.get(METRIC_REST_ENDPOINT, (Map)params);
        return this.mapper.toMeasures(response);
    }
}

