/*
 * Decompiled with CFR 0.152.
 */
package io.github.devsecops.engine.domain.sonar.utils;

import io.github.devsecops.engine.domain.sonar.model.Metric;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.json.JSONArray;
import org.json.JSONObject;

public class SonarMeasureMapper {
    private static final Integer NOT_FOUND_VALUE = -1;

    public Map<Metric, Integer> toMeasures(String response) {
        JSONArray measuresJsonArray = new JSONObject(response).getJSONObject("component").getJSONArray("measures");
        return Arrays.asList(Metric.values()).stream().collect(Collectors.toMap(i -> i, metric -> this.getMetricValue((Metric)((Object)metric), measuresJsonArray)));
    }

    private Integer getMetricValue(Metric metric, JSONArray measuresJsonArray) {
        return this.getStringMetricValue(metric, measuresJsonArray).map(value -> this.toInteger(metric, (String)value)).orElse(NOT_FOUND_VALUE);
    }

    private Optional<String> getStringMetricValue(Metric metric, JSONArray measuresJsonArray) {
        for (int i = 0; i < measuresJsonArray.length(); ++i) {
            JSONObject jsonObject = measuresJsonArray.getJSONObject(i);
            String currentMetric = jsonObject.getString("metric");
            if (!metric.getName().equals(currentMetric)) continue;
            String output = jsonObject.getString("value");
            return Optional.of(output.trim());
        }
        return Optional.empty();
    }

    private Integer toInteger(Metric metric, String value) {
        switch (metric.getType()) {
            case INTEGER: {
                return Integer.valueOf(value);
            }
            case DOUBLE: 
            case RATING: {
                return (int)Double.parseDouble(value);
            }
        }
        return NOT_FOUND_VALUE;
    }
}

