/*
 * Decompiled with CFR 0.152.
 */
package io.github.devsecops.engine.mojos.genconfig;

import io.github.devsecops.engine.core.CommandInvoker;
import io.github.devsecops.engine.core.Log;
import io.github.devsecops.engine.core.contract.Command;
import io.github.devsecops.engine.core.contract.Factory;
import io.github.devsecops.engine.core.contract.Invoker;
import io.github.devsecops.engine.core.model.BuildParam;
import io.github.devsecops.engine.core.model.Environment;
import io.github.devsecops.engine.domain.genconfig.commands.AbstractConfigCommand;
import io.github.devsecops.engine.domain.resolver.path.PathResolverBuilder;
import io.github.devsecops.engine.domain.resolver.strategy.Resolver;
import io.github.devsecops.engine.domain.resolver.utils.TokenReplacement;
import java.util.Map;
import java.util.Stack;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service
public class GenConfigFactory
implements Factory<Invoker> {
    @Autowired
    private Log logger;
    @Autowired
    private PathResolverBuilder pathResolverFactory;
    @Autowired
    private TokenReplacement tokenReplacement;
    @Autowired
    @Qualifier(value="YAML")
    private AbstractConfigCommand yamlGenConfigFile;
    @Autowired
    @Qualifier(value="LIQUIBASE")
    private AbstractConfigCommand liquibaseGenConfigFile;

    @Override
    public Invoker build(Map<String, String> parameters) throws Exception {
        Object resolver = this.pathResolverFactory.build((Map)parameters);
        this.tokenReplacement.setResolver((Resolver)resolver);
        Environment env = Environment.valueOf(parameters.get(BuildParam.ENV.name()).toUpperCase());
        this.yamlGenConfigFile.setEnv(env);
        Stack<Command> commands = new Stack<Command>();
        commands.push(this.yamlGenConfigFile);
        commands.push(this.liquibaseGenConfigFile);
        return new CommandInvoker(commands, this.logger);
    }
}

