/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsqueue.util.redis;

import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.ValueOperations;

public class RedisCache {
    private static final Logger log = LoggerFactory.getLogger(RedisCache.class);
    @Resource
    public RedisTemplate redisTemplate;

    public boolean hasKey(String key) {
        return this.redisTemplate.hasKey((Object)key);
    }

    public <T> T get(String key) {
        ValueOperations operation = this.redisTemplate.opsForValue();
        return (T)operation.get((Object)key);
    }

    public <T> void setCacheObject(String key, T value) {
        this.redisTemplate.opsForValue().set((Object)key, value);
    }

    public <T> ValueOperations<String, T> set(String key, T value, Integer timeout) {
        ValueOperations operation = this.redisTemplate.opsForValue();
        operation.set((Object)key, value, (long)timeout.intValue(), TimeUnit.SECONDS);
        return operation;
    }

    public <T> void setCacheObject(String key, T value, Integer timeout, TimeUnit timeUnit) {
        this.redisTemplate.opsForValue().set((Object)key, value, (long)timeout.intValue(), timeUnit);
    }

    public boolean expire(String key, long timeout) {
        return this.expire(key, timeout, TimeUnit.SECONDS);
    }

    public boolean expire(String key, long timeout, TimeUnit unit) {
        return this.redisTemplate.expire((Object)key, timeout, unit);
    }

    public <T> T getCacheObject(String key) {
        ValueOperations operation = this.redisTemplate.opsForValue();
        return (T)operation.get((Object)key);
    }

    public boolean deleteObject(String key) {
        return this.redisTemplate.delete((Object)key);
    }

    public <T> long setCacheList(String key, List<T> dataList) {
        Long count = this.redisTemplate.opsForList().rightPushAll((Object)key, dataList);
        return count == null ? 0L : count;
    }

    public <T> long add2CacheList(String key, T data) {
        Long count = this.redisTemplate.opsForList().rightPush((Object)key, data);
        return count == null ? 0L : count;
    }

    public <T> Object fetchRemoveCacheList(String key) {
        return this.redisTemplate.opsForList().leftPop((Object)key);
    }

    public <T> List<T> getCacheList(String key) {
        return this.redisTemplate.opsForList().range((Object)key, 0L, -1L);
    }
}

