/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsqueue.util.redis;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.jsontype.PolymorphicTypeValidator;
import com.fasterxml.jackson.databind.jsontype.impl.LaissezFaireSubTypeValidator;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import javax.annotation.Resource;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.connection.lettuce.LettuceConnectionFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.serializer.Jackson2JsonRedisSerializer;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.data.redis.serializer.StringRedisSerializer;

@Configuration
@ConditionalOnProperty(prefix="ds.queue", value={"enableDsRedisConfig"})
public class RedisQueueConfig {
    @Resource
    private RedisTemplate<String, Object> redisTemplate;

    @Bean
    public RedisTemplate<String, Object> setSerializer() {
        LettuceConnectionFactory connectionFactory = (LettuceConnectionFactory)this.redisTemplate.getConnectionFactory();
        this.redisTemplate.setConnectionFactory((RedisConnectionFactory)connectionFactory);
        Jackson2JsonRedisSerializer serializer = new Jackson2JsonRedisSerializer(Object.class);
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.setDateFormat((DateFormat)new SimpleDateFormat("yyyy-MM-dd HH:mm:ss"));
        objectMapper.setVisibility(PropertyAccessor.ALL, JsonAutoDetect.Visibility.ANY);
        objectMapper.activateDefaultTyping((PolymorphicTypeValidator)LaissezFaireSubTypeValidator.instance, ObjectMapper.DefaultTyping.NON_FINAL);
        this.redisTemplate.setKeySerializer((RedisSerializer)new StringRedisSerializer());
        this.redisTemplate.setHashKeySerializer((RedisSerializer)new StringRedisSerializer());
        this.redisTemplate.setValueSerializer((RedisSerializer)serializer);
        this.redisTemplate.setHashValueSerializer((RedisSerializer)serializer);
        this.redisTemplate.afterPropertiesSet();
        return this.redisTemplate;
    }
}

