/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsqueue.util.task;

import io.github.dsqueue.config.CacheDsqueueConfig;
import io.github.dsqueue.util.redis.RedisCache;
import io.github.dsqueue.util.task.LockHelper;
import io.github.dsqueue.util.task.TaskInfo;
import io.github.dsqueue.util.task.TaskServerCallable;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.LockSupport;
import javax.annotation.PreDestroy;
import javax.annotation.Resource;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Component;

@Component
public class ServerConsumerRunable
implements Runnable {
    private Boolean stopMain = false;
    private Boolean isRunned = false;
    @Resource
    private LockHelper lockHelper;
    @Resource
    private CacheDsqueueConfig cacheDsqueueConfig;
    @Resource(name="taskThreadPool")
    private ThreadPoolTaskExecutor dsqueueSendThreadPool;
    @Resource(name="dsqueueRedisCache")
    private RedisCache redisCache;

    public Boolean getStopMain() {
        return this.stopMain;
    }

    public void setStopMain(Boolean stopMain) {
        this.stopMain = stopMain;
    }

    public Boolean getRunned() {
        return this.isRunned;
    }

    public void setRunned(Boolean runned) {
        this.isRunned = runned;
    }

    @PreDestroy
    public void shutDown() {
        this.setStopMain(true);
        LockSupport.parkNanos(2000000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Long v = 1L;
        try {
            this.lockHelper.getConsumerLock().lock();
            this.setRunned(true);
            this.lockHelper.getConsumerCondition().await(1L, TimeUnit.SECONDS);
            this.lockHelper.getConsumerLock().unlock();
            do {
                if (this.stopMain.booleanValue()) {
                    LockSupport.parkNanos(1000000L);
                    return;
                }
                List mailList = null;
                mailList = this.redisCache.getCacheList(this.cacheDsqueueConfig.getQueueCacheKey());
                if (mailList != null) {
                    if (mailList.size() > 0) {
                        for (TaskInfo info : mailList) {
                            TaskInfo passer;
                            Object temp;
                            if (info.getStatus() != null) {
                                if (!info.getStatus().booleanValue()) {
                                    this.lockHelper.getConsumerLock().lock();
                                    this.lockHelper.getConsumerCondition().await();
                                    temp = null;
                                    temp = this.redisCache.fetchRemoveCacheList(this.cacheDsqueueConfig.getQueueCacheKey());
                                    if (temp != null) {
                                        passer = (TaskInfo)temp;
                                        TaskServerCallable callable = new TaskServerCallable("consumer", info.getSendTestTag(), info);
                                        Future callInfo = this.dsqueueSendThreadPool.submit((Callable)callable);
                                        v = v + 1L;
                                        this.redisCache.setCacheObject("cache_consumer_total", v);
                                        info.setStatus(true);
                                    }
                                    this.lockHelper.getConsumerLock().unlock();
                                }
                                continue;
                            }
                            this.lockHelper.getConsumerLock().lock();
                            this.lockHelper.getConsumerCondition().await();
                            temp = null;
                            temp = this.redisCache.fetchRemoveCacheList(this.cacheDsqueueConfig.getQueueCacheKey());
                            if (temp != null) {
                                passer = (TaskInfo)temp;
                                info.setStatus(true);
                            }
                            this.lockHelper.getConsumerLock().unlock();
                            if (!this.stopMain.booleanValue()) continue;
                            LockSupport.parkNanos(1000000L);
                            return;
                        }
                        continue;
                    }
                    v = v + 1L;
                    this.redisCache.setCacheObject("cache_consumer_tag", v);
                    continue;
                }
                v = v + 1L;
                this.redisCache.setCacheObject("cache_consumer_tag", v);
            } while (!this.stopMain.booleanValue());
        }
        catch (IllegalArgumentException | InterruptedException | NullPointerException e) {
            e.printStackTrace();
            v = v + 1L;
            this.redisCache.setCacheObject("cache_consumer_tag", "3");
        }
        finally {
            this.lockHelper.getConsumerLock().unlock();
        }
    }
}

