/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsqueue.util.task;

import cn.hutool.json.JSON;
import cn.hutool.json.JSONArray;
import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;
import io.github.dsqueue.config.CacheDsqueueConfig;
import io.github.dsqueue.util.redis.RedisCache;
import io.github.dsqueue.util.service.DsqueueProduceService;
import io.github.dsqueue.util.service.ProduceAction;
import io.github.dsqueue.util.task.LockHelper;
import io.github.dsqueue.util.task.TaskInfo;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.LockSupport;
import javax.annotation.PreDestroy;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ServerProducerRunable
implements Runnable {
    private Boolean stopMain = false;
    private Boolean isRunned = false;
    private Boolean debug = true;
    @Resource
    private LockHelper lockHelper;
    @Resource
    private CacheDsqueueConfig cacheDsqueueConfig;
    @Resource
    private DsqueueProduceService dsqueueProduceService;
    @Autowired(required=false)
    private ProduceAction produceAction;
    @Autowired(required=false)
    private RedisCache redisCache;

    public Boolean getStopMain() {
        return this.stopMain;
    }

    public void setStopMain(Boolean stopMain) {
        this.stopMain = stopMain;
    }

    public Boolean getRunned() {
        return this.isRunned;
    }

    public void setRunned(Boolean runned) {
        this.isRunned = runned;
    }

    @PreDestroy
    public void shutDown() {
        this.setStopMain(true);
        LockSupport.parkNanos(2000000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        if (this.debug.booleanValue()) {
            this.redisCache.deleteObject(this.lockHelper.getCacheKey());
        }
        Long v = 1L;
        try {
            this.lockHelper.getProduceLock().lock();
            this.setRunned(true);
            this.lockHelper.getProduceCondition().await(1L, TimeUnit.SECONDS);
            this.lockHelper.getProduceLock().unlock();
            do {
                JSONObject item;
                JSONArray array;
                TaskInfo passer;
                ArrayList<TaskInfo> temp;
                Long tempV;
                List mailList = null;
                mailList = this.redisCache.getCacheList(this.cacheDsqueueConfig.getQueueCacheKey());
                if (mailList != null) {
                    if (mailList.size() > 0) {
                        if (this.stopMain.booleanValue()) {
                            LockSupport.parkNanos(1000000L);
                            return;
                        }
                        this.lockHelper.getConsumerLock().lock();
                        assert (this.produceAction != null);
                        TaskInfo taskInfo = this.dsqueueProduceService.runProduceAction(this.produceAction);
                        if (taskInfo != null) {
                            this.redisCache.add2CacheList(this.cacheDsqueueConfig.getQueueCacheKey(), taskInfo);
                        }
                        this.lockHelper.getConsumerCondition().signal();
                        this.lockHelper.getConsumerLock().unlock();
                        if (!this.stopMain.booleanValue()) continue;
                        LockSupport.parkNanos(1000000L);
                        return;
                    }
                    this.redisCache.deleteObject(this.cacheDsqueueConfig.getQueueCacheKey());
                    this.lockHelper.getConsumerLock().lock();
                    v = v + 1L;
                    tempV = 1000L + v;
                    temp = new ArrayList();
                    passer = new TaskInfo();
                    passer.setStatus(true);
                    passer.setSendTestTag(this.lockHelper.getSendTag());
                    passer.setCurrentDate(new Date());
                    passer.setThreadName("dsqueue-producer-" + tempV.toString());
                    passer.setSeqno(v);
                    passer.setTaskServiceBeanName("dsqueueTaskServiceImpl");
                    passer.setInvokeMethodName("doTask");
                    passer.setIsValidClassName(false);
                    array = new JSONArray();
                    item = new JSONObject();
                    item.set("type", (Object)"String");
                    item.set("value", (Object)"dsqueue size 0");
                    array.put((Object)item);
                    passer.setMethodParamJson(JSONUtil.toJsonPrettyStr((JSON)array));
                    temp.add(passer);
                    this.redisCache.setCacheList(this.cacheDsqueueConfig.getQueueCacheKey(), temp);
                    this.lockHelper.getConsumerCondition().signal();
                    this.lockHelper.getConsumerLock().unlock();
                    continue;
                }
                this.lockHelper.getConsumerLock().lock();
                v = v + 1L;
                tempV = 1000L + v;
                temp = new ArrayList<TaskInfo>();
                passer = new TaskInfo();
                passer.setStatus(true);
                passer.setSendTestTag(this.lockHelper.getSendTag());
                passer.setCurrentDate(new Date());
                passer.setThreadName("dsqueue-producer-" + tempV.toString());
                passer.setSeqno(v);
                passer.setTaskServiceBeanName("dsqueueTaskServiceImpl");
                passer.setInvokeMethodName("doTask");
                passer.setIsValidClassName(false);
                array = new JSONArray();
                item = new JSONObject();
                item.set("type", (Object)"String");
                item.set("value", (Object)"dsqueue null");
                array.put((Object)item);
                passer.setMethodParamJson(JSONUtil.toJsonPrettyStr((JSON)array));
                temp.add(passer);
                this.redisCache.setCacheList(this.cacheDsqueueConfig.getQueueCacheKey(), temp);
                this.lockHelper.getConsumerCondition().signal();
                this.lockHelper.getConsumerLock().unlock();
            } while (!this.stopMain.booleanValue());
            return;
        }
        catch (IllegalArgumentException | InterruptedException | NullPointerException e) {
            e.printStackTrace();
            v = v + 1L;
            this.redisCache.setCacheObject("cache_producer_tag", v);
            return;
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
        finally {
            this.lockHelper.getProduceLock().unlock();
        }
    }
}

