/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsqueue.util.task;

import cn.hutool.extra.spring.SpringUtil;
import cn.hutool.json.JSONArray;
import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;
import io.github.dsqueue.util.task.TaskInfo;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.LinkedList;
import java.util.List;

public class TaskInvokeUtil {
    public static void invokeMethod(TaskInfo taskInfo) throws Exception {
        String beanName = taskInfo.getTaskServiceBeanName();
        String methodName = taskInfo.getInvokeMethodName();
        List<Object[]> methodParams = TaskInvokeUtil.getMethodParams(taskInfo.getMethodParamJson());
        if (!taskInfo.getIsValidClassName().booleanValue()) {
            Object bean = SpringUtil.getBean((String)beanName);
            TaskInvokeUtil.invokeMethod(bean, methodName, methodParams);
        } else {
            Object bean = Class.forName(beanName).newInstance();
            TaskInvokeUtil.invokeMethod(bean, methodName, methodParams);
        }
    }

    private static void invokeMethod(Object bean, String methodName, List<Object[]> methodParams) throws NoSuchMethodException, SecurityException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        if (methodParams.size() > 0) {
            Method method = bean.getClass().getDeclaredMethod(methodName, TaskInvokeUtil.getMethodParamsType(methodParams));
            method.invoke(bean, TaskInvokeUtil.getMethodParamsValue(methodParams));
        } else {
            Method method = bean.getClass().getDeclaredMethod(methodName, new Class[0]);
            method.invoke(bean, new Object[0]);
        }
    }

    public static List<Object[]> getMethodParams(String methodParamJson) {
        JSONArray jsonArray = JSONUtil.parseArray((String)methodParamJson);
        LinkedList<Object[]> classs = new LinkedList<Object[]>();
        for (int i = 0; i < jsonArray.size(); ++i) {
            JSONObject param = jsonArray.getJSONObject((Object)i);
            if ("String".equals(param.get((Object)"type"))) {
                classs.add(new Object[]{param.getStrEscaped((Object)"value"), String.class});
                continue;
            }
            if ("Boolean".equals(param.get((Object)"type"))) {
                classs.add(new Object[]{param.getBool((Object)"value"), Boolean.class});
                continue;
            }
            if ("Long".equals(param.get((Object)"type"))) {
                classs.add(new Object[]{param.getLong((Object)"value"), Long.class});
                continue;
            }
            if ("Double".equals(param.get((Object)"type"))) {
                classs.add(new Object[]{param.getDouble((Object)"value"), Double.class});
                continue;
            }
            classs.add(new Object[]{param.getInt((Object)"value"), Integer.class});
        }
        return classs;
    }

    public static Class<?>[] getMethodParamsType(List<Object[]> methodParams) {
        Class[] classs = new Class[methodParams.size()];
        int index = 0;
        for (Object[] os : methodParams) {
            classs[index] = (Class)os[1];
            ++index;
        }
        return classs;
    }

    public static Object[] getMethodParamsValue(List<Object[]> methodParams) {
        Object[] classs = new Object[methodParams.size()];
        int index = 0;
        for (Object[] os : methodParams) {
            classs[index] = os[0];
            ++index;
        }
        return classs;
    }
}

