/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsqueue.util.task;

import io.github.dsqueue.config.CacheDsqueueConfig;
import io.github.dsqueue.util.task.ServerConsumerRunable;
import io.github.dsqueue.util.task.ServerProducerRunable;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Component;

@Component
public class TaskServerMainThread
implements ApplicationRunner,
ApplicationListener<ContextRefreshedEvent> {
    private static final Logger log = LoggerFactory.getLogger(TaskServerMainThread.class);
    @Resource(name="consumerThreadPool")
    private ThreadPoolTaskExecutor consumerExecutor;
    @Resource(name="producerThreadPool")
    private ThreadPoolTaskExecutor producerExecutor;
    @Resource
    private ServerConsumerRunable consumerRunable;
    @Resource
    private ServerProducerRunable producerRunable;
    @Resource
    private CacheDsqueueConfig cacheDsqueueConfig;

    public void run(ApplicationArguments args) throws Exception {
    }

    private void runConsumer() {
        this.consumerExecutor.submit((Runnable)this.consumerRunable);
    }

    private void runProducer() {
        this.producerExecutor.submit((Runnable)this.producerRunable);
    }

    public void onApplicationEvent(ContextRefreshedEvent event) {
        if (this.cacheDsqueueConfig.getConsumerEnable().booleanValue() && this.cacheDsqueueConfig.getProduceEnable().booleanValue()) {
            log.info("task Server main thread run");
            this.runConsumer();
            this.runProducer();
        }
    }
}

