/*
 * Decompiled with CFR 0.152.
 */
package de.factoryfx.javafx.javascript.editor.attribute.visualisation;

import impl.org.controlsfx.skin.AutoCompletePopup;
import javafx.beans.binding.Bindings;
import javafx.beans.value.ObservableNumberValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.event.Event;
import javafx.scene.Node;
import javafx.scene.control.ListView;
import javafx.scene.control.MultipleSelectionModel;
import javafx.scene.control.Skin;
import javafx.scene.control.cell.TextFieldListCell;
import javafx.scene.input.MouseButton;
import javafx.util.StringConverter;
import org.controlsfx.control.textfield.AutoCompletionBinding;

public class ContentAssistPopupSkin
implements Skin<AutoCompletePopup<String>> {
    private final AutoCompletePopup<String> control;
    private final ListView<String> suggestionList;
    static final int LIST_CELL_HEIGHT = 24;

    public ContentAssistPopupSkin(AutoCompletePopup<String> control) {
        this.control = control;
        this.suggestionList = new ListView(control.getSuggestions());
        this.suggestionList.getStyleClass().add((Object)"auto-complete-popup");
        this.suggestionList.getStylesheets().add((Object)AutoCompletionBinding.class.getResource("autocompletion.css").toExternalForm());
        this.suggestionList.prefHeightProperty().bind((ObservableValue)Bindings.min((ObservableNumberValue)control.visibleRowCountProperty(), (ObservableNumberValue)Bindings.size((ObservableList)this.suggestionList.getItems())).multiply(24).add(18));
        this.suggestionList.setCellFactory(TextFieldListCell.forListView((StringConverter)control.getConverter()));
        this.suggestionList.prefWidthProperty().bind((ObservableValue)control.prefWidthProperty());
        this.suggestionList.maxWidthProperty().bind((ObservableValue)control.maxWidthProperty());
        this.suggestionList.minWidthProperty().bind((ObservableValue)control.minWidthProperty());
        this.registerEventListener();
    }

    private void registerEventListener() {
        this.suggestionList.setOnMouseClicked(me -> {
            if (me.getButton() == MouseButton.PRIMARY) {
                this.onSuggestionChoosen((String)this.suggestionList.getSelectionModel().getSelectedItem());
            }
        });
        this.suggestionList.setOnKeyPressed(ke -> {
            switch (ke.getCode()) {
                case ENTER: {
                    this.onSuggestionChoosen((String)this.suggestionList.getSelectionModel().getSelectedItem());
                    break;
                }
                case ESCAPE: {
                    if (!this.control.isHideOnEscape()) break;
                    this.control.hide();
                    break;
                }
            }
        });
    }

    private void onSuggestionChoosen(String suggestion) {
        if (suggestion != null) {
            Event.fireEvent(this.control, (Event)new AutoCompletePopup.SuggestionEvent((Object)suggestion));
        }
    }

    public Node getNode() {
        return this.suggestionList;
    }

    public AutoCompletePopup<String> getSkinnable() {
        return this.control;
    }

    public void dispose() {
    }

    public void selectItem(String item) {
        this.suggestionList.scrollTo((Object)item);
        MultipleSelectionModel selectionModel = this.suggestionList.getSelectionModel();
        selectionModel.clearSelection();
        selectionModel.select((Object)item);
    }

    public void unselect() {
        this.suggestionList.getSelectionModel().clearSelection();
    }
}

