/*
 * Decompiled with CFR 0.152.
 */
package de.factoryfx.javafx.javascript.editor.attribute.visualisation;

import com.google.javascript.jscomp.CheckLevel;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.SourceFile;
import de.factoryfx.javafx.javascript.editor.attribute.visualisation.CodeHighlightingAssistant;
import de.factoryfx.javafx.javascript.editor.attribute.visualisation.ContentAssistPopupSkin;
import de.factoryfx.javafx.javascript.editor.attribute.visualisation.ContentAssistant;
import de.factoryfx.javafx.javascript.editor.attribute.visualisation.ErrorsAndWarningsAssistant;
import de.factoryfx.javafx.javascript.editor.attribute.visualisation.Proposal;
import de.factoryfx.javafx.javascript.editor.attribute.visualisation.Span;
import de.factoryfx.javascript.data.attributes.types.Javascript;
import impl.org.controlsfx.skin.AutoCompletePopup;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.NavigableMap;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import javafx.application.Platform;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.WeakChangeListener;
import javafx.geometry.Insets;
import javafx.geometry.Orientation;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.control.Skin;
import javafx.scene.control.SplitPane;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.StackPane;
import javafx.stage.PopupWindow;
import org.fxmisc.richtext.CodeArea;
import org.fxmisc.richtext.LineNumberFactory;
import org.fxmisc.richtext.StyleSpansBuilder;
import org.fxmisc.richtext.StyledTextArea;

public class JavascriptVisual {
    private final List<SourceFile> externs;

    public JavascriptVisual(List<SourceFile> externs) {
        this.externs = externs;
    }

    public Node createContent(SimpleObjectProperty<Javascript<?>> boundTo) {
        return new RootNode(this.externs, boundTo);
    }

    static final class ContentAssistPopup
    extends AutoCompletePopup<String> {
        ContentAssistPopup() {
        }

        public void selectItem(String item) {
            ((ContentAssistPopupSkin)this.getSkin()).selectItem(item);
        }

        protected Skin<?> createDefaultSkin() {
            return new ContentAssistPopupSkin(this);
        }

        public void unselect() {
            ((ContentAssistPopupSkin)this.getSkin()).unselect();
        }
    }

    static class RootNode
    extends StackPane {
        final Consumer<List<JSError>> processErrorsAndWarnings = this::processErrorsAndWarnings;
        final Consumer<NavigableMap<Integer, List<Proposal>>> processProoposals = this::processProposals;
        final Consumer<List<Span>> processHighlighting = this::processHighlighting;
        final ContentAssistant contentAssistant;
        final ErrorsAndWarningsAssistant errorsAndWarningsAssistant;
        final CodeHighlightingAssistant codeHighlightingAssistant = new CodeHighlightingAssistant(new WeakReference<Consumer<List<Span>>>(this.processHighlighting));
        final CodeArea codeArea = new CodeArea();
        final ListView<JSError> errorsAndWarnings = new ListView();
        final ContentAssistPopup popup = new ContentAssistPopup();
        final ChangeListener<Javascript> onUpdateScript;
        NavigableMap<Integer, List<Proposal>> currentProposals;

        RootNode(List<SourceFile> externs, SimpleObjectProperty<Javascript<?>> boundTo) {
            this.getStylesheets().add((Object)((Object)((Object)this)).getClass().getResource("jsstyle.css").toExternalForm());
            ArrayList<SourceFile> externalSources = new ArrayList<SourceFile>();
            externalSources.addAll(externs);
            this.contentAssistant = new ContentAssistant(externalSources, new WeakReference<Consumer<NavigableMap<Integer, List<Proposal>>>>(this.processProoposals));
            this.errorsAndWarningsAssistant = new ErrorsAndWarningsAssistant(externalSources, new WeakReference<Consumer<List<JSError>>>(this.processErrorsAndWarnings));
            this.codeArea.setParagraphGraphicFactory(LineNumberFactory.get((StyledTextArea)this.codeArea));
            this.onUpdateScript = (observable, oldValue, newValue) -> {
                if (newValue != null && !newValue.getCode().equals(this.codeArea.getText())) {
                    this.codeArea.replaceText(newValue.getCode());
                }
                this.updateAssistants((Javascript)boundTo.get());
            };
            boundTo.addListener((ChangeListener)new WeakChangeListener(this.onUpdateScript));
            this.codeArea.onKeyPressedProperty().set(this::handleKeys);
            this.codeArea.onKeyReleasedProperty().set(this::handleKeys);
            this.codeArea.setPopupWindow((PopupWindow)this.popup);
            if (boundTo.get() != null) {
                this.codeArea.insertText(0, ((Javascript)boundTo.get()).getCode());
            }
            this.codeArea.textProperty().addListener((a, b, newValue) -> {
                if (boundTo.get() == null || ((Javascript)boundTo.get()).getCode() == null) {
                    boundTo.set((Object)new Javascript(newValue));
                } else if (!((Javascript)boundTo.get()).getCode().equals(newValue)) {
                    boundTo.set((Object)((Javascript)boundTo.get()).copyWithNewCode(newValue));
                }
            });
            this.errorsAndWarnings.setCellFactory(lv -> {
                ListCell cell = new ListCell();
                Function<JSError, String> toText = e -> e.getType().key + ". " + e.description + " at line " + (e.getLineNumber() != -1 ? String.valueOf(e.getLineNumber()) : "(unknown line)") + " : " + (e.getCharno() != -1 ? String.valueOf(e.getCharno() + 1) : "(unknown column)");
                cell.itemProperty().addListener((a, b, newValue) -> {
                    cell.getStyleClass().removeIf(c -> Arrays.asList(CheckLevel.values()).stream().anyMatch(l -> l.name().equals(c)));
                    if (newValue != null) {
                        cell.getStyleClass().add((Object)newValue.getType().level.name());
                        cell.setText(((String)toText.apply((JSError)newValue)).replaceAll("\\s+", " "));
                    } else {
                        cell.setText("");
                    }
                });
                cell.setOnMouseClicked(e -> {
                    this.jumpToError((ListCell<JSError>)cell);
                    Platform.runLater(() -> ((CodeArea)this.codeArea).requestFocus());
                });
                cell.setOnKeyTyped(e -> {
                    if (e.getCode() == KeyCode.ENTER) {
                        this.jumpToError((ListCell<JSError>)cell);
                    } else if (!e.getCode().isNavigationKey()) {
                        Platform.runLater(() -> {
                            this.codeArea.requestFocus();
                            this.codeArea.getOnKeyTyped().handle(e);
                        });
                    }
                });
                return cell;
            });
            this.errorsAndWarnings.getSelectionModel().selectedItemProperty().addListener((a, oldValue, newValue) -> {});
            this.updateAssistants((Javascript)boundTo.get());
            SplitPane area = new SplitPane();
            area.setOrientation(Orientation.VERTICAL);
            area.setDividerPosition(0, 0.8);
            area.getItems().add((Object)this.codeArea);
            area.getItems().add(this.errorsAndWarnings);
            SplitPane.setResizableWithParent((Node)this.codeArea, (Boolean)true);
            this.getChildren().add((Object)area);
            StackPane.setMargin((Node)area, (Insets)Insets.EMPTY);
        }

        private void jumpToError(ListCell<JSError> cell) {
            JSError newValue = (JSError)cell.getItem();
            if (newValue != null) {
                Platform.runLater(() -> this.codeArea.positionCaret(this.codeArea.position(newValue.lineNumber - 1, newValue.getCharno()).toOffset()));
            }
        }

        private void handleKeys(KeyEvent keyEvent) {
            if (keyEvent.getEventType() == KeyEvent.KEY_PRESSED && keyEvent.isControlDown() && keyEvent.getCode() == KeyCode.SPACE && !this.popup.isShowing()) {
                this.popup.show(((Scene)this.sceneProperty().get()).getWindow());
                this.updateProposals();
            }
            if (this.popup.isShowing()) {
                if (keyEvent.getEventType() == KeyEvent.KEY_RELEASED && keyEvent.getCode() != KeyCode.UP && keyEvent.getCode() != KeyCode.DOWN) {
                    this.updateProposals();
                }
                if (this.popup.getSuggestions().isEmpty()) {
                    this.popup.hide();
                }
            }
        }

        private void updateProposals() {
            int pos;
            if (this.currentProposals == null || this.currentProposals.isEmpty()) {
                return;
            }
            List<Proposal> proposals = this.currentProposals.floorEntry(this.codeArea.getCaretPosition()).getValue();
            String text = this.codeArea.getText();
            int pos2 = pos = this.codeArea.getCaretPosition();
            while (pos > 0 && Character.isJavaIdentifierPart(text.charAt(pos - 1))) {
                --pos;
            }
            String prefix = text.substring(pos, pos2);
            while (pos2 < text.length() && Character.isJavaIdentifierPart(text.charAt(pos2))) {
                ++pos2;
            }
            ArrayList<Proposal> copy = new ArrayList<Proposal>(proposals);
            int from = pos;
            int to = pos2;
            Consumer<String> applySuggestion = s -> this.codeArea.replaceText(from, to, s);
            this.popup.onSuggestionProperty().setValue(v -> {
                applySuggestion.accept((String)v.getSuggestion());
                this.popup.hide();
            });
            this.popup.getSuggestions().clear();
            ArrayList<String> garbageSuggestions = new ArrayList<String>();
            garbageSuggestions.add("hasOwnProperty()");
            garbageSuggestions.add("isPrototypeOf()");
            garbageSuggestions.add("propertyIsEnumerable()");
            garbageSuggestions.add("toJSON()");
            garbageSuggestions.add("toLocaleString()");
            garbageSuggestions.add("toSource()");
            garbageSuggestions.add("toString()");
            garbageSuggestions.add("unwatch()");
            garbageSuggestions.add("valueOf()");
            garbageSuggestions.add("watch()");
            garbageSuggestions.add("constructor");
            List suggestions = copy.stream().map(s -> s.insertString).filter(s -> !garbageSuggestions.contains(s)).collect(Collectors.toList());
            this.popup.getSuggestions().addAll(suggestions);
            this.popup.unselect();
            for (String suggestion : suggestions) {
                if (!suggestion.startsWith(prefix)) continue;
                this.popup.selectItem(suggestion);
            }
        }

        private void updateAssistants(Javascript<?> javascript) {
            if (javascript == null) {
                javascript = new Javascript("");
            }
            this.contentAssistant.accept(javascript);
            this.errorsAndWarningsAssistant.accept(javascript);
            this.codeHighlightingAssistant.accept(javascript);
        }

        private void processHighlighting(List<Span> spans) {
            if (!spans.isEmpty()) {
                spans.sort((s1, s2) -> Integer.valueOf(s1.from).compareTo(s2.from));
                StyleSpansBuilder spansBuilder = new StyleSpansBuilder();
                int last = 0;
                int textLength = this.codeArea.getText().length();
                for (Span s : spans) {
                    int newFrom = Math.min(s.from, textLength);
                    if (newFrom > last) {
                        spansBuilder.add(Collections.emptyList(), newFrom - last);
                    }
                    spansBuilder.add(Collections.singleton(s.style()), s.len);
                    last = s.from + s.len;
                }
                if (last < textLength) {
                    spansBuilder.add(Collections.emptyList(), textLength - last);
                }
                try {
                    this.codeArea.setStyleSpans(0, spansBuilder.create());
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
        }

        private void processErrorsAndWarnings(List<JSError> jsErrors) {
            if (!jsErrors.isEmpty()) {
                if (!this.errorsAndWarnings.getStyleClass().contains((Object)"error")) {
                    this.errorsAndWarnings.getStyleClass().add((Object)"error");
                }
            } else {
                this.errorsAndWarnings.getStyleClass().removeAll((Object[])new String[]{"error"});
            }
            this.errorsAndWarnings.getItems().setAll(jsErrors);
        }

        private void processProposals(NavigableMap<Integer, List<Proposal>> p) {
            this.currentProposals = p;
        }
    }
}

