/*
 * Decompiled with CFR 0.152.
 */
package de.factoryfx.javafx.javascript.editor.attribute.visualisation;

import de.factoryfx.javafx.javascript.editor.attribute.visualisation.BackgroundEvaluatingAssistant;
import java.lang.ref.WeakReference;
import java.util.function.Consumer;
import javafx.application.Platform;

public abstract class AssistantBase<I, R>
implements Consumer<I> {
    private final WeakReference<Consumer<R>> consumer;
    private BackgroundEvaluatingAssistant<I> backgroundEvaluator = new BackgroundEvaluatingAssistant();

    public AssistantBase(WeakReference<Consumer<R>> consumer) {
        this.consumer = consumer;
        this.backgroundEvaluator.start(input -> {
            Consumer fConsumer = (Consumer)consumer.get();
            if (fConsumer == null) {
                this.dispose();
                return;
            }
            Object result = this.process(input);
            Platform.runLater(() -> fConsumer.accept(result));
        });
    }

    protected abstract R process(I var1);

    public final void dispose() {
        if (this.backgroundEvaluator != null) {
            this.backgroundEvaluator.stop();
            this.backgroundEvaluator = null;
        }
    }

    protected final void finalize() {
        this.dispose();
    }

    @Override
    public final void accept(I newValue) {
        this.backgroundEvaluator.update(newValue);
    }
}

