/*
 * Decompiled with CFR 0.152.
 */
package de.factoryfx.javafx.javascript.editor.attribute.visualisation;

import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.Compiler;
import com.google.javascript.jscomp.CompilerOptions;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.Scope;
import com.google.javascript.jscomp.SourceFile;
import com.google.javascript.jscomp.TypedScope;
import com.google.javascript.jscomp.Var;
import com.google.javascript.jscomp.WarningLevel;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.StaticSourceFile;
import com.google.javascript.rhino.Token;
import com.google.javascript.rhino.jstype.FunctionType;
import com.google.javascript.rhino.jstype.JSType;
import com.google.javascript.rhino.jstype.NullType;
import com.google.javascript.rhino.jstype.ObjectType;
import com.google.javascript.rhino.jstype.UnionType;
import de.factoryfx.javafx.javascript.editor.attribute.visualisation.DiscardOutputStream;
import de.factoryfx.javafx.javascript.editor.attribute.visualisation.Proposal;
import de.factoryfx.javascript.data.attributes.types.Javascript;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Optional;
import java.util.Stack;
import java.util.TreeMap;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import java.util.logging.Level;
import java.util.stream.Collectors;

public class ContentAssist {
    public NavigableMap<Integer, List<Proposal>> findProposals(List<SourceFile> externalSources, final Javascript<?> text) {
        final TreeMap<Integer, List<Proposal>> ret = new TreeMap<Integer, List<Proposal>>(){

            @Override
            public List<Proposal> put(Integer key, List<Proposal> value) {
                return super.put(key, value);
            }
        };
        try {
            Compiler compiler = this.createCompiler();
            ArrayList<SourceFile> internalSource = new ArrayList<SourceFile>();
            internalSource.add(SourceFile.fromCode((String)"decl", (String)text.getHeaderCode()));
            internalSource.add(SourceFile.fromCode((String)"intern", (String)text.getCode()));
            ArrayList<SourceFile> externalSource = new ArrayList<SourceFile>(externalSources);
            externalSource.add(SourceFile.fromCode((String)"apiDecl", (String)text.getDeclarationCode()));
            compiler.compile(externalSource, internalSource, this.creataCompilerOptions());
            Node root = compiler.getRoot();
            NodeTraversal.ScopedCallback scopedCallback = new NodeTraversal.ScopedCallback(){
                Stack<TypedScope> scopes = new Stack();

                public void enterScope(NodeTraversal t) {
                    this.scopes.add(t.getTypedScope());
                }

                public void exitScope(NodeTraversal t) {
                    this.scopes.pop();
                }

                public boolean shouldTraverse(NodeTraversal nodeTraversal, Node n, Node parent) {
                    if ("intern".equals(n.getSourceFileName())) {
                        ContentAssist.this.proposals(text.getCode(), this.scopes.peek(), n, ret);
                    }
                    return true;
                }

                public void visit(NodeTraversal t, Node n, Node parent) {
                }
            };
            NodeTraversal.traverseTyped((AbstractCompiler)compiler, (Node)root, (NodeTraversal.Callback)scopedCallback);
        }
        catch (RuntimeException e) {
            e.printStackTrace();
        }
        return ret;
    }

    private void proposals(String code, TypedScope scope, Node inspectedNode, Map<Integer, List<Proposal>> proposals) {
        List<Var> vars = this.getVars((Scope)scope);
        ArrayList<Var> internalVars = new ArrayList<Var>();
        ArrayList<Var> externalVars = new ArrayList<Var>();
        vars.forEach(s -> {
            if (Optional.ofNullable(s.getSourceFile()).map(f -> f.isExtern() || "extern".equals(f.getName()) || f.getName().startsWith("library")).orElse(false).booleanValue()) {
                externalVars.add((Var)s);
            } else if (s.getNameNode().getStaticSourceFile() != null) {
                internalVars.add((Var)s);
            }
        });
        externalVars.sort((v1, v2) -> {
            boolean ext1 = Optional.ofNullable(v1.getSourceFile()).map(this::isFromProjectSources).orElse(false);
            boolean ext2 = Optional.ofNullable(v2.getSourceFile()).map(this::isFromProjectSources).orElse(false);
            if (ext1) {
                if (ext2) {
                    return this.compareJsType((Var)v1, (Var)v2);
                }
                return -1;
            }
            if (ext2) {
                return 1;
            }
            return this.compareJsType((Var)v1, (Var)v2);
        });
        internalVars.sort(this::compareJsType);
        if (inspectedNode.getToken() == Token.SCRIPT) {
            List<Proposal> ret = this.createScriptProposals(externalVars);
            proposals.put(0, ret);
        } else if (inspectedNode.getToken() == Token.BLOCK) {
            this.createBlockProposals(code, inspectedNode, proposals, internalVars, externalVars);
        } else if (inspectedNode.getToken() == Token.EXPR_RESULT) {
            this.createExprResultProposals(code, inspectedNode, proposals, internalVars, externalVars);
        } else if (inspectedNode.getToken() == Token.NEW) {
            this.createNewProposals(inspectedNode, proposals, internalVars, externalVars);
        } else if (inspectedNode.getToken() == Token.FUNCTION_TYPE) {
            proposals.put(inspectedNode.getSourceOffset(), new ArrayList());
        } else if (inspectedNode.getToken() == Token.GETPROP) {
            this.createGetPropProposals(code, inspectedNode, proposals, internalVars, externalVars);
        } else if (inspectedNode.getToken() != Token.FUNCTION) {
            if (inspectedNode.getToken() == Token.CALL) {
                this.createCallProposals(inspectedNode, proposals, internalVars, externalVars);
            } else if (inspectedNode.getToken() == Token.RETURN) {
                this.createReturnProposals(inspectedNode, proposals, internalVars, externalVars);
            } else if (inspectedNode.getToken() == Token.VAR) {
                this.createVarProposals(code, inspectedNode, proposals, internalVars, externalVars);
            } else if (Arrays.asList(Token.SUB, Token.ADD, Token.MUL, Token.DIV).contains(inspectedNode.getToken())) {
                this.createArithmeticProposals(code, inspectedNode, proposals, internalVars, externalVars);
            } else if (Arrays.asList(Token.ASSIGN, Token.ASSIGN_ADD, Token.ASSIGN_DIV, Token.ASSIGN_SUB, Token.ASSIGN_MUL).contains(inspectedNode.getToken())) {
                this.createAssignProposals(code, inspectedNode, proposals, internalVars, externalVars);
            }
        }
    }

    private boolean isFromProjectSources(StaticSourceFile v) {
        return "extern".equals(v.getName()) || v.getName().equals("decl");
    }

    private void createVarProposals(String code, Node inspectedNode, Map<Integer, List<Proposal>> proposals, ArrayList<Var> internalVars, ArrayList<Var> externalVars) {
        Node currentNode = inspectedNode.getFirstChild();
        if (currentNode != null) {
            this.createExprResultProposals(code, currentNode, proposals, internalVars, externalVars);
            currentNode = currentNode.getFirstChild();
            if (currentNode != null && this.isIntern(currentNode)) {
                ArrayList visibleVars = new ArrayList();
                internalVars.stream().filter(v -> v.getNameNode().getSourceOffset() < inspectedNode.getSourceOffset()).forEach(visibleVars::add);
                externalVars.stream().sorted((v1, v2) -> {
                    boolean decl2;
                    boolean decl1 = this.isFromDeclarations(v1.getNameNode());
                    if (decl1 == (decl2 = this.isFromDeclarations(v2.getNameNode()))) {
                        return 0;
                    }
                    if (decl1) {
                        return -1;
                    }
                    return 1;
                }).forEach(visibleVars::add);
                visibleVars.sort(this::compareTypeQuality);
                int idx = this.skipWhitespaceBefore(code, currentNode);
                proposals.put(idx, visibleVars.stream().map(v -> new Proposal(v.getName())).collect(Collectors.toList()));
            }
        }
    }

    private int skipWhitespaceBefore(String code, Node currentNode) {
        int idx;
        for (idx = currentNode.getSourceOffset(); idx > 0 && Character.isWhitespace(code.charAt(idx - 1)); --idx) {
        }
        return idx;
    }

    private void createArithmeticProposals(String code, Node inspectedNode, Map<Integer, List<Proposal>> proposals, ArrayList<Var> internalVars, ArrayList<Var> externalVars) {
        JSType returnType = inspectedNode.getJSType();
        for (Node currentNode = inspectedNode.getFirstChild(); currentNode != null; currentNode = currentNode.getNext()) {
            if (!this.isIntern(currentNode)) continue;
            this.addArithmeticAndAssignProposals(code, inspectedNode, proposals, internalVars, externalVars, returnType, currentNode);
        }
    }

    private void addArithmeticAndAssignProposals(String code, Node inspectedNode, Map<Integer, List<Proposal>> proposals, ArrayList<Var> internalVars, ArrayList<Var> externalVars, JSType returnType, Node currentNode) {
        ArrayList visibleVars = new ArrayList();
        internalVars.stream().filter(v -> v.getNameNode().getSourceOffset() < inspectedNode.getSourceOffset()).filter(v1 -> this.canCastTo(v1.getNameNode().getJSType(), returnType)).forEach(visibleVars::add);
        externalVars.stream().filter(v1 -> this.canCastTo(v1.getNameNode().getJSType(), returnType)).forEach(visibleVars::add);
        visibleVars.sort(this::compareTypeQuality);
        int idx = this.skipWhitespaceBefore(code, currentNode);
        proposals.put(idx, visibleVars.stream().map(v -> new Proposal(v.getName())).collect(Collectors.toList()));
    }

    private void createAssignProposals(String code, Node inspectedNode, Map<Integer, List<Proposal>> proposals, ArrayList<Var> internalVars, ArrayList<Var> externalVars) {
        JSType returnType = inspectedNode.getJSType();
        Node currentNode = inspectedNode.getFirstChild();
        if (currentNode != null) {
            currentNode = currentNode.getNext();
        }
        if (currentNode != null && this.isIntern(currentNode)) {
            this.addArithmeticAndAssignProposals(code, inspectedNode, proposals, internalVars, externalVars, returnType, currentNode);
        }
    }

    private void createReturnProposals(Node inspectedNode, Map<Integer, List<Proposal>> proposals, ArrayList<Var> internalVars, ArrayList<Var> externalVars) {
        Node currentNode;
        for (currentNode = inspectedNode; currentNode != null && this.isIntern(currentNode) && currentNode.getToken() != Token.FUNCTION; currentNode = currentNode.getParent()) {
        }
        if (currentNode != null && this.isIntern(currentNode)) {
            ArrayList<Var> visibleVars = new ArrayList<Var>();
            internalVars.stream().filter(v -> v.getNameNode().getSourceOffset() < inspectedNode.getSourceOffset()).forEach(visibleVars::add);
            visibleVars.addAll(externalVars);
            JSType functionType = currentNode.getJSType();
            Optional functionReturnType = Optional.ofNullable(functionType).filter(f -> functionType instanceof FunctionType).map(f -> (FunctionType)f).flatMap(ft -> Optional.ofNullable(ft.getReturnType()));
            functionReturnType.ifPresent(ret -> {
                visibleVars.removeIf(v -> v.getNameNode().getJSType() == null);
                visibleVars.removeIf(v -> !this.canCastTo(v.getNameNode().getJSType(), (JSType)ret));
            });
            visibleVars.sort(this::compareTypeQuality);
            proposals.put(inspectedNode.getSourceOffset() + Token.RETURN.name().length() + 1, visibleVars.stream().map(v -> new Proposal(v.getName())).collect(Collectors.toList()));
        }
    }

    private void createCallProposals(Node inspectedNode, Map<Integer, List<Proposal>> proposals, ArrayList<Var> internalVars, ArrayList<Var> externalVars) {
        Node firstChild = inspectedNode.getFirstChild();
        ArrayList<Var> visiableVars = new ArrayList<Var>();
        internalVars.stream().filter(v -> v.getNameNode().getSourceOffset() < inspectedNode.getSourceOffset()).forEach(visiableVars::add);
        visiableVars.addAll(externalVars);
        if (firstChild != null && firstChild.getJSType() != null && firstChild.getJSType() instanceof FunctionType) {
            FunctionType ft = (FunctionType)firstChild.getJSType();
            int paramNum = 0;
            for (Node paramterNode : ft.getParameters()) {
                ++paramNum;
                ArrayList filteredVars = new ArrayList();
                JSType parameterNodeType = this.fixNullType(paramterNode.getJSType());
                visiableVars.stream().filter(v -> this.noTypeFound((Var)v) || this.viableAssignment(v.getNameNode().getJSType(), parameterNodeType)).forEach(filteredVars::add);
                Node argumentNode = inspectedNode.getChildCount() > paramNum ? inspectedNode.getChildAtIndex(paramNum) : null;
                filteredVars.sort(this::compareTypeQuality);
                ArrayList proposalList = filteredVars.stream().map(v -> new Proposal(v.getName())).collect(Collectors.toCollection(ArrayList::new));
                if (parameterNodeType.isFunctionType() && (argumentNode == null || !argumentNode.getJSType().isFunctionType())) {
                    String newFunction = this.createFunctionDeclaration(parameterNodeType.toMaybeFunctionType());
                    proposalList.add(0, new Proposal(newFunction));
                }
                if (argumentNode != null) {
                    proposals.put(argumentNode.getSourceOffset(), proposalList);
                    continue;
                }
                proposals.put(inspectedNode.getSourceOffset() + inspectedNode.getLength() - 1, proposalList);
                break;
            }
        } else {
            proposals.put(inspectedNode.getSourceOffset() + 1, visiableVars.stream().map(v -> new Proposal(v.getName())).collect(Collectors.toList()));
        }
    }

    private String createFunctionDeclaration(FunctionType functionType) {
        StringBuilder sb = new StringBuilder();
        sb.append("function(");
        HashSet usedParameterNames = new HashSet();
        functionType.getParameters().forEach(n -> {
            JSType argumentType = n.getJSType();
            sb.append("/** @type {");
            String displayName = argumentType.getDisplayName();
            if (!argumentType.isNullable()) {
                sb.append("!");
            }
            sb.append(displayName).append("} */ ");
            Object parameterName = n.getOriginalName();
            if (parameterName == null) {
                parameterName = Character.toLowerCase(displayName.charAt(0)) + displayName.substring(1);
            }
            Object tryName = parameterName;
            int i = 2;
            while (!usedParameterNames.add(tryName)) {
                tryName = (String)parameterName + i;
                ++i;
            }
            sb.append((String)tryName);
            sb.append(", ");
        });
        if (functionType.getParameters().iterator().hasNext()) {
            sb.setLength(sb.length() - 2);
        }
        sb.append(") { }");
        return sb.toString();
    }

    private void createGetPropProposals(String code, Node inspectedNode, Map<Integer, List<Proposal>> proposals, ArrayList<Var> internalVars, ArrayList<Var> externalVars) {
        JSType t;
        Node firstChild = inspectedNode.getFirstChild();
        Optional<JSType> firstChildType = Optional.ofNullable(firstChild.getJSType());
        if (firstChildType.isPresent() && (t = this.fixNullType(firstChildType.get())) instanceof ObjectType) {
            int sp;
            ObjectType ot = ObjectType.cast((JSType)t);
            ArrayList internalProperties = new ArrayList();
            ArrayList externalProperties = new ArrayList();
            Comparator sortProps = (s1, s2) -> {
                Optional<JSType> propertyType1 = Optional.ofNullable(ot.getPropertyType(s1));
                Optional<JSType> propertyType2 = Optional.ofNullable(ot.getPropertyType(s2));
                if (propertyType1.isPresent()) {
                    return propertyType2.map(jsType -> this.compareJsType((JSType)propertyType1.get(), (JSType)jsType)).orElse(-1);
                }
                if (propertyType2.isPresent()) {
                    return 1;
                }
                return 0;
            };
            ot.getPropertyNames().stream().filter(n -> !n.startsWith("__")).forEach(n -> {
                if (this.isIntern(ot.getPropertyDefSite(n))) {
                    internalProperties.add(n);
                } else {
                    externalProperties.add(n);
                }
            });
            internalProperties.sort(sortProps);
            externalProperties.sort(sortProps);
            UnaryOperator addFunctionBrackets = s -> {
                Optional<JSType> propertyType = Optional.ofNullable(ot.getPropertyType(s));
                boolean isFunction = propertyType.map(pt -> pt instanceof FunctionType).orElse(false);
                return isFunction ? s + "()" : s;
            };
            internalProperties.replaceAll(addFunctionBrackets);
            externalProperties.replaceAll(addFunctionBrackets);
            ArrayList ret = new ArrayList();
            int sourcePosition = firstChild.getSourceOffset();
            if (sourcePosition > -1) {
                sourcePosition += firstChild.getLength();
                while (sourcePosition < code.length() && Character.isWhitespace(code.charAt(sourcePosition))) {
                    ++sourcePosition;
                }
                if (sourcePosition < code.length() && '.' == code.charAt(sourcePosition)) {
                    ++sourcePosition;
                }
            }
            if ((sp = sourcePosition) > -1) {
                if (ot instanceof FunctionType) {
                    internalVars.stream().filter(v -> v.getNameNode().getSourceOffset() < sp).map(v -> new Proposal(v.getName())).forEach(ret::add);
                    internalProperties.stream().map(Proposal::new).forEach(ret::add);
                    externalVars.stream().map(v -> new Proposal(v.getName())).forEach(ret::add);
                    externalProperties.stream().map(Proposal::new).forEach(ret::add);
                } else {
                    internalProperties.stream().map(Proposal::new).forEach(ret::add);
                    externalProperties.stream().map(Proposal::new).forEach(ret::add);
                }
                proposals.put(sourcePosition, ret);
            }
        }
    }

    private void createNewProposals(Node inspectedNode, Map<Integer, List<Proposal>> proposals, ArrayList<Var> internalVars, ArrayList<Var> externalVars) {
        Node firstChild = inspectedNode.getFirstChild();
        ArrayList ret = new ArrayList();
        Predicate<Var> isClass = v -> v.getNode().getJSType().isConstructor();
        internalVars.stream().filter(v -> v.getNameNode().getSourceOffset() < firstChild.getSourceOffset()).filter(isClass).map(v -> new Proposal(v.getName())).forEach(ret::add);
        externalVars.stream().filter(isClass).map(v -> new Proposal(v.getName())).forEach(ret::add);
        int sourceOffset = firstChild.getSourceOffset() + 1;
        if (sourceOffset < 1) {
            sourceOffset = inspectedNode.getSourceOffset() + inspectedNode.getLength();
        }
        proposals.put(sourceOffset, ret);
    }

    private void createBlockProposals(String code, Node inspectedNode, Map<Integer, List<Proposal>> proposals, ArrayList<Var> internalVars, ArrayList<Var> externalVars) {
        int sourceOffset;
        ArrayList ret = new ArrayList();
        internalVars.stream().filter(v -> v.getNameNode().getSourceOffset() < inspectedNode.getSourceOffset()).map(v -> new Proposal(v.getName())).forEach(ret::add);
        externalVars.stream().map(v -> new Proposal(v.getName())).forEach(ret::add);
        proposals.put(inspectedNode.getSourceOffset() + 1, ret);
        Node lastChild = inspectedNode.getLastChild();
        ret = new ArrayList();
        internalVars.stream().filter(v -> v.getNameNode().getSourceOffset() < inspectedNode.getSourceOffset()).map(v -> new Proposal(v.getName())).forEach(ret::add);
        externalVars.stream().map(v -> new Proposal(v.getName())).forEach(ret::add);
        int n = sourceOffset = lastChild != null ? lastChild.getSourceOffset() + lastChild.getLength() : inspectedNode.getSourceOffset() + inspectedNode.getLength();
        if (code.length() > sourceOffset && Character.isWhitespace(code.charAt(sourceOffset))) {
            ++sourceOffset;
        }
        if (code.length() > sourceOffset && !proposals.containsKey(sourceOffset)) {
            proposals.put(sourceOffset, ret);
        }
    }

    private void createExprResultProposals(String code, Node inspectedNode, Map<Integer, List<Proposal>> proposals, ArrayList<Var> internalVars, ArrayList<Var> externalVars) {
        int sourceOffset;
        ArrayList ret = new ArrayList();
        Node lastChild = inspectedNode.getLastChild();
        internalVars.stream().filter(v -> v.getNameNode().getSourceOffset() < inspectedNode.getSourceOffset()).map(v -> new Proposal(v.getName())).forEach(ret::add);
        externalVars.stream().map(v -> new Proposal(v.getName())).forEach(ret::add);
        int n = sourceOffset = lastChild != null ? lastChild.getSourceOffset() + lastChild.getLength() : inspectedNode.getSourceOffset() + inspectedNode.getLength();
        while (sourceOffset < code.length() && !Character.isWhitespace(sourceOffset) && code.charAt(++sourceOffset - 1) != ';') {
        }
        if (sourceOffset < code.length() && !proposals.containsKey(sourceOffset)) {
            proposals.put(sourceOffset, ret);
        }
        if ((sourceOffset = inspectedNode.getSourceOffset()) >= 0) {
            proposals.put(sourceOffset, ret);
        }
    }

    private List<Proposal> createScriptProposals(ArrayList<Var> externalVars) {
        ArrayList<Proposal> ret = new ArrayList<Proposal>();
        externalVars.stream().map(v -> new Proposal(v.getName())).forEach(ret::add);
        return ret;
    }

    private int compareJsType(Var v1, Var v2) {
        JSType t1 = this.fixNullType(v1.getNameNode().getJSType());
        JSType t2 = this.fixNullType(v2.getNameNode().getJSType());
        return this.compareJsType(t1, t2);
    }

    private int compareJsType(JSType t1, JSType t2) {
        t1 = this.fixNullType(t1);
        t2 = this.fixNullType(t2);
        if (this.isPreferredValueType(t1)) {
            if (this.isPreferredValueType(t2)) {
                return 0;
            }
            return -1;
        }
        if (this.isPreferredValueType(t2)) {
            return 1;
        }
        if (t1.isConstructor()) {
            if (t2.isConstructor()) {
                return 0;
            }
            return 1;
        }
        if (t2.isConstructor()) {
            return -1;
        }
        if (t1.isFunctionType()) {
            if (t2.isFunctionType()) {
                return this.compareSource(((FunctionType)t1).getSource(), ((FunctionType)t2).getSource());
            }
            return -1;
        }
        if (t2.isFunctionType()) {
            return 1;
        }
        return 0;
    }

    private int compareSource(Node source1, Node source2) {
        if (source1 == null) {
            return source2 == null ? 0 : 1;
        }
        if (source2 == null) {
            return -1;
        }
        if (this.isFromProjectSources(source1.getStaticSourceFile())) {
            if (this.isFromProjectSources(source2.getStaticSourceFile())) {
                return 0;
            }
            return -1;
        }
        if (this.isFromProjectSources(source2.getStaticSourceFile())) {
            return 1;
        }
        return 0;
    }

    private boolean isPreferredValueType(JSType t1) {
        if (t1.isConstructor()) {
            return false;
        }
        return t1.isInstanceType() || t1.isNumberValueType() || t1.isBooleanValueType() || t1.isStringValueType();
    }

    private int compareTypeQuality(Var v1, Var v2) {
        if (v1.getNameNode().getJSType() == null) {
            if (v1.getNameNode().getJSType() != null) {
                return 1;
            }
            return 0;
        }
        if (v2.getNameNode().getJSType() == null) {
            return -1;
        }
        JSType v1Type = v1.getNameNode().getJSType();
        JSType v2Type = v2.getNameNode().getJSType();
        return this.compareTypeQuality(v1Type, v2Type);
    }

    private int compareTypeQuality(JSType v1Type, JSType v2Type) {
        if (v1Type.isUnknownType()) {
            if (!v2Type.isUnknownType()) {
                return 1;
            }
            return 0;
        }
        if (v2Type.isUnknownType()) {
            return -1;
        }
        if (v1Type.isUnionType()) {
            if (!v2Type.isUnionType()) {
                return 1;
            }
            return 0;
        }
        if (v2Type.isUnionType()) {
            return -1;
        }
        return 0;
    }

    private boolean noTypeFound(Var v) {
        return v.getNameNode().getJSType() == null;
    }

    private boolean viableAssignment(JSType rhsType, JSType lhsType) {
        if (lhsType == null || lhsType.isUnknownType()) {
            return true;
        }
        if (rhsType == null || rhsType.isUnknownType()) {
            return false;
        }
        if (lhsType.isFunctionType()) {
            if (!rhsType.isFunctionType()) {
                return false;
            }
            JSType lhsReturnType = lhsType.toMaybeFunctionType().getReturnType();
            JSType rhsReturnType = rhsType.toMaybeFunctionType().getReturnType();
            if (!this.viableAssignment(rhsReturnType, lhsReturnType)) {
                return false;
            }
            ArrayList arguments = new ArrayList();
            rhsType.toMaybeFunctionType().getParameters().forEach(n -> arguments.add(n.getJSType()));
            return lhsType.toMaybeFunctionType().acceptsArguments(arguments);
        }
        return this.canCastTo(rhsType, lhsType);
    }

    boolean canCastTo(JSType rhsType, JSType lhsType) {
        if (this.fixNullType(rhsType).isUnknownType()) {
            return this.fixNullType(lhsType).isUnknownType();
        }
        return rhsType.canCastTo(lhsType);
    }

    private JSType fixNullType(JSType jsType) {
        UnionType ut;
        if (jsType instanceof UnionType && (ut = (UnionType)jsType).getAlternates().size() == 2 && ut.getAlternates().stream().anyMatch(t -> t instanceof NullType)) {
            return ut.getAlternates().stream().filter(t -> !(t instanceof NullType)).findAny().get();
        }
        return jsType;
    }

    private CompilerOptions creataCompilerOptions() {
        CompilerOptions options = new CompilerOptions();
        options.setNewTypeInference(true);
        options.setCheckSymbols(true);
        options.setCheckSuspiciousCode(false);
        options.setInferTypes(true);
        options.setInferConst(true);
        options.setClosurePass(true);
        options.setPreserveDetailedSourceInfo(true);
        options.setContinueAfterErrors(true);
        options.setSkipNonTranspilationPasses(false);
        options.setIncrementalChecks(CompilerOptions.IncrementalCheckMode.OFF);
        options.setChecksOnly(true);
        options.setCheckTypes(true);
        WarningLevel.QUIET.setOptionsForWarningLevel(options);
        return options;
    }

    private Compiler createCompiler() {
        try {
            Compiler closureCompiler = new Compiler(new PrintStream((OutputStream)new DiscardOutputStream(), false, "UTF-8"));
            closureCompiler.disableThreads();
            Compiler.setLoggingLevel((Level)Level.INFO);
            return closureCompiler;
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    private boolean isIntern(Node node) {
        return !node.isFromExterns();
    }

    private boolean isFromDeclarations(Node node) {
        return "decl".equals(node.getSourceFileName());
    }

    public List<Var> getVars(Scope scope) {
        ArrayList<Var> ret = new ArrayList<Var>();
        while (scope != null) {
            scope.getVarIterable().forEach(ret::add);
            scope = scope.getParent();
        }
        return ret;
    }
}

