/*
 * Decompiled with CFR 0.152.
 */
package io.github.factoryfx.javafx.javascript.editor.attribute.visualisation;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BackgroundEvaluatingAssistant<I> {
    private static final Logger logger = LoggerFactory.getLogger(BackgroundEvaluatingAssistant.class);
    private ComputationTask<I> thread;
    private BlockingQueue<I> inputQueue = new ArrayBlockingQueue<I>(1);
    private final Object lock = new Object();
    private static final ThreadPoolExecutor executor;

    public BackgroundEvaluatingAssistant() {
        this.thread = new ComputationTask<Object>(this.inputQueue, i -> {});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(I input) {
        Object object = this.lock;
        synchronized (object) {
            this.inputQueue.clear();
            this.inputQueue.add(input);
            executor.submit(this.thread.runnable());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(Consumer<I> processor) {
        Object object = this.lock;
        synchronized (object) {
            this.thread = new ComputationTask<I>(this.inputQueue, processor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Object object = this.lock;
        synchronized (object) {
            this.thread = new ComputationTask<Object>(this.inputQueue, i -> {});
        }
    }

    static {
        ThreadGroup group = new ThreadGroup("assistants");
        int numThread = Math.max(1, Runtime.getRuntime().availableProcessors() - 1);
        executor = new ThreadPoolExecutor(numThread, numThread, 1L, TimeUnit.DAYS, new ArrayBlockingQueue<Runnable>(200), r -> {
            Thread t = new Thread(group, r);
            t.setDaemon(true);
            return t;
        });
        executor.setRejectedExecutionHandler(new ThreadPoolExecutor.CallerRunsPolicy());
    }

    static class ComputationTask<I> {
        private final BlockingQueue<I> inputQueue;
        private final Consumer<I> processor;

        public ComputationTask(BlockingQueue<I> inputQueue, Consumer<I> processor) {
            this.inputQueue = inputQueue;
            this.processor = processor;
        }

        public Runnable runnable() {
            return () -> {
                try {
                    Object input = this.inputQueue.poll();
                    if (input != null) {
                        this.processor.accept(input);
                    }
                }
                catch (Error | RuntimeException e) {
                    logger.info("Could not compile source", e);
                }
            };
        }
    }
}

