/*
 * Decompiled with CFR 0.152.
 */
package ch.framedev.simplejavautils;

import ch.framedev.simplejavautils.SimpleJavaUtils;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import java.util.function.BiConsumer;

public class Settings {
    private Properties properties;
    private final File file;
    private String resource;
    private Class<?> clazz;

    public Settings(File file) {
        this.file = file;
        if (!file.exists()) {
            if (file.getParentFile() != null && !file.getParentFile().exists() && !file.getParentFile().mkdir()) {
                throw new IllegalStateException("Could not create directory : " + file.getParentFile().getAbsolutePath());
            }
            try {
                if (file.createNewFile()) {
                    throw new IllegalStateException("Could not create new File : " + file.getAbsolutePath());
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        try {
            this.loadProperties();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public Settings(String resource, Class<?> clazz, File file) {
        this.resource = resource;
        this.clazz = clazz;
        this.file = file;
        if (!file.exists()) {
            if (file.getParentFile() != null && !file.getParentFile().exists() && !file.getParentFile().mkdir()) {
                throw new IllegalStateException("Could not create directory : " + file.getParentFile().getAbsolutePath());
            }
            try {
                if (file.createNewFile()) {
                    throw new IllegalStateException("Could not create new File : " + file.getAbsolutePath());
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        try {
            this.loadProperties();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void loadProperties() throws IOException {
        if (!this.file.exists()) {
            Properties resourceProperties = this.loadResouceProperties();
            this.properties = new Properties();
            this.properties.putAll((Map<?, ?>)resourceProperties);
            this.properties.store(new FileWriter(this.file), "");
        } else {
            Properties resourceProperties = this.loadResouceProperties();
            this.properties = new Properties();
            this.properties.load(new FileReader(this.file));
            resourceProperties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, value) -> {
                if (!this.properties.containsKey(key)) {
                    this.properties.put(key, value);
                }
            }));
            this.properties.store(new FileWriter(this.file), "");
        }
    }

    public Properties loadResouceProperties() throws IOException {
        Properties resourceProperties = new Properties();
        if (this.resource == null) {
            resourceProperties.load(new FileReader(new SimpleJavaUtils().getFromResourceFile("settings.properties", SimpleJavaUtils.class)));
        } else {
            resourceProperties.load(new FileReader(new SimpleJavaUtils().getFromResourceFile(this.resource, this.clazz)));
        }
        return resourceProperties;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public void save() {
        try {
            this.properties.store(new FileWriter(this.file), "");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void setProperty(String key, String value) {
        this.properties.setProperty(key, value);
    }

    public String getProperty(String key) {
        return this.properties.getProperty(key);
    }

    public boolean contains(String key) {
        return this.properties.containsKey(key);
    }
}

