/*
 * Decompiled with CFR 0.152.
 */
package ch.framedev.simplejavautils;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;

public class SystemMemory {
    private final Runtime runtime = Runtime.getRuntime();

    public long getAllocatedTotal() {
        return this.runtime.totalMemory();
    }

    public long getAllocatedFree() {
        return this.runtime.freeMemory();
    }

    public long getUsed() {
        return this.getAllocatedTotal() - this.getAllocatedFree();
    }

    public boolean isAtMaximumAllocation() {
        return this.getAllocatedTotal() == this.getTotal();
    }

    public long getUnallocated() {
        return this.getTotal() - this.getAllocatedTotal();
    }

    public long getTotal() {
        return this.runtime.maxMemory();
    }

    public long getFree() {
        return this.getTotal() - this.getUsed();
    }

    public boolean isBounded() {
        return this.getTotal() != Long.MAX_VALUE;
    }

    public String getCurrentStats() {
        StringWriter backing = new StringWriter();
        PrintWriter out = new PrintWriter((Writer)backing, false);
        out.printf("Total: allocated %,d (%.1f%%) out of possible %,d; %s, %s %,d%n", this.getAllocatedTotal(), Float.valueOf((float)this.getAllocatedTotal() / (float)this.getTotal() * 100.0f), this.getTotal(), this.isBounded() ? "bounded" : "unbounded", this.isAtMaximumAllocation() ? "maxed out" : "can grow", this.getUnallocated());
        out.printf("Used: %,d; %.1f%% of total (%,d); %.1f%% of allocated (%,d)%n", this.getUsed(), Float.valueOf((float)this.getUsed() / (float)this.getTotal() * 100.0f), this.getTotal(), Float.valueOf((float)this.getUsed() / (float)this.getAllocatedTotal() * 100.0f), this.getAllocatedTotal());
        out.printf("Free: %,d (%.1f%%) out of %,d total; %,d (%.1f%%) out of %,d allocated%n", this.getFree(), Float.valueOf((float)this.getFree() / (float)this.getTotal() * 100.0f), this.getTotal(), this.getAllocatedFree(), Float.valueOf((float)this.getAllocatedFree() / (float)this.getAllocatedTotal() * 100.0f), this.getAllocatedTotal());
        out.flush();
        return backing.toString();
    }
}

