/*
 * Decompiled with CFR 0.152.
 */
package ch.framedev.simplejavautils;

import java.util.PrimitiveIterator;
import java.util.Random;

public class CustomGenerators {
    public int randomInt(int min, int max) {
        return new IntRandomNumberGenerator(min, max).nextInt();
    }

    public double randomDouble(double min, double max) {
        return new DoubleRandomNumberGenerator(min, max).nextDouble();
    }

    public static final class IntRandomNumberGenerator {
        private PrimitiveIterator.OfInt randomIterator;
        private int min;
        private int max;

        public IntRandomNumberGenerator() {
        }

        public IntRandomNumberGenerator setMin(int min) {
            this.min = min;
            return this;
        }

        public IntRandomNumberGenerator setMax(int max) {
            this.max = max;
            return this;
        }

        public int getMin() {
            return this.min;
        }

        public int getMax() {
            return this.max;
        }

        public IntRandomNumberGenerator(int min, int max) {
            this.randomIterator = new Random().ints(min, max + 1).iterator();
        }

        public int nextInt() {
            if (this.randomIterator == null) {
                this.randomIterator = new Random().ints(this.min, this.max + 1).iterator();
            }
            return this.randomIterator.nextInt();
        }
    }

    public static final class DoubleRandomNumberGenerator {
        private PrimitiveIterator.OfDouble randomIterator;
        private double min;
        private double max;

        public DoubleRandomNumberGenerator() {
        }

        public DoubleRandomNumberGenerator setMin(double min) {
            this.min = min;
            return this;
        }

        public DoubleRandomNumberGenerator setMax(double max) {
            this.max = max;
            return this;
        }

        public double getMin() {
            return this.min;
        }

        public double getMax() {
            return this.max;
        }

        public DoubleRandomNumberGenerator(double min, double max) {
            this.randomIterator = new Random().doubles(min, max + 1.0).iterator();
        }

        public double nextDouble() {
            if (this.randomIterator == null) {
                this.randomIterator = new Random().doubles(this.min, this.max + 1.0).iterator();
            }
            return this.randomIterator.nextDouble();
        }
    }
}

