/*
 * Decompiled with CFR 0.152.
 */
package org.brijframework.resources.files.json;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.brijframework.resources.Resource;
import org.brijframework.resources.files.MetaResource;
import org.brijframework.util.asserts.Assertion;
import org.brijframework.util.resouces.JSONUtil;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class JsonResource
extends MetaResource {
    private String jsonresource;

    public JsonResource() {
    }

    public JsonResource(String resource) {
        this.setJsonResource(resource);
    }

    public JsonResource(File path) {
        this.setFile(path);
    }

    public JsonResource(Resource metaResource) {
        this.setFile(metaResource.getFile());
        this.setPath(metaResource.getPath());
    }

    public void setJsonResource(String jsonresource) {
        this.jsonresource = jsonresource;
    }

    public String getJsonResource() {
        if (this.jsonresource == null) {
            if (this.getPath() != null) {
                this.setJsonResource(this.getResource());
            }
            if (this.getFile() != null) {
                this.setJsonResource(this.getResource());
            }
        }
        return this.jsonresource;
    }

    public boolean isValidJson() {
        return this.getJsonResource() != null && this.getJsonResource() != "" && (this.getJsonResource().trim().startsWith("{") && this.getJsonResource().trim().endsWith("}") || this.getJsonResource().trim().startsWith("[") && this.getJsonResource().trim().endsWith("]"));
    }

    public boolean isJsonObject() {
        if (this.isValidJson()) {
            return this.getJsonResource().trim().startsWith("{") && this.getJsonResource().trim().endsWith("}");
        }
        return false;
    }

    public boolean isJsonList() {
        if (this.isValidJson()) {
            return this.getJsonResource().trim().startsWith("[") && this.getJsonResource().trim().endsWith("]");
        }
        return false;
    }

    public JSONObject toJsonObject() {
        if (this.isJsonObject()) {
            return JSONUtil.getJSONObjectFromJSONString((String)this.getJsonResource());
        }
        return null;
    }

    public JSONArray toJsonList() {
        if (this.isJsonList()) {
            return JSONUtil.getJSONArrayFromJSONString((String)this.getJsonResource());
        }
        if (this.isJsonObject()) {
            return new JSONArray().put((Object)JSONUtil.getJSONObjectFromJSONString((String)this.getJsonResource()));
        }
        return null;
    }

    public boolean containsKey(String keys) {
        try {
            if (this.isJsonObject()) {
                JSONObject jsonObject = this.toJsonObject();
                return this.containsKey(jsonObject, keys);
            }
            if (this.isJsonList()) {
                JSONArray array = this.toJsonList();
                for (int i = 0; i < array.length(); ++i) {
                    boolean isContain = this.containsKey(array.getJSONObject(i), keys);
                    if (isContain) continue;
                    return false;
                }
                return true;
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return false;
    }

    public boolean containsKey(JSONObject jsonObject, String keys) throws JSONException {
        int i;
        Assertion.notNull((Object)jsonObject, (String)"this is required . it must not be null or empty");
        String[] keySet = keys.split("\\.");
        JSONObject current = jsonObject;
        for (i = 0; i < keySet.length - 1; ++i) {
            if (!jsonObject.has(keySet[i])) {
                return false;
            }
            current = jsonObject.getJSONObject(keySet[i]);
        }
        return current.has(keySet[i]);
    }

    public JSONObject keyReplace(JSONObject contant, String oldKey, String newKey) throws JSONException {
        Assertion.notNull((Object)contant, (String)"this is required . it must not be null or empty");
        JSONObject json = new JSONObject();
        Iterator keys = contant.keys();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            Object value = contant.get(key);
            if (value instanceof JSONObject) {
                value = this.keyReplace((JSONObject)value, oldKey, newKey);
            } else if (value instanceof JSONArray) {
                JSONArray array = (JSONArray)value;
                value = this.keyReplace(array, oldKey, newKey);
            }
            if (key.equals(oldKey)) {
                json.put(newKey, value);
                continue;
            }
            json.put(key, value);
        }
        return json;
    }

    private JSONArray keyReplace(JSONArray contant, String oldKey, String newKey) throws JSONException {
        Assertion.notNull((Object)contant, (String)"this is required . it must not be null or empty");
        JSONArray json = new JSONArray();
        for (int i = 0; i < contant.length(); ++i) {
            if (contant.get(i) instanceof JSONObject) {
                json.put((Object)this.keyReplace(contant.getJSONObject(i), oldKey, newKey));
                continue;
            }
            json.put(contant.get(i));
        }
        return json;
    }

    public <T> T toJson() {
        if (this.isJsonObject()) {
            return (T)this.toJsonObject();
        }
        if (this.isJsonList()) {
            return (T)this.toJsonList();
        }
        return null;
    }

    public <T> T getProperty(String keys) {
        if (this.isJsonObject()) {
            return this.getPropertyFromJsonObject(keys);
        }
        if (this.isJsonList()) {
            return this.getPropertyFromJsonList(keys);
        }
        return null;
    }

    public JSONArray getPropertyList(String keys) {
        Object _json = null;
        if (this.isJsonObject()) {
            _json = this.getPropertyFromJsonObject(keys);
        }
        if (this.isJsonList()) {
            _json = this.getPropertyFromJsonList(keys);
        }
        if (_json instanceof JSONObject) {
            return new JSONArray().put(_json);
        }
        return _json != null ? (JSONArray)_json : new JSONArray();
    }

    private <T> T getPropertyFromJsonObject(String keys) {
        try {
            return this.getProperty(this.toJsonObject(), keys);
        }
        catch (JSONException e) {
            e.printStackTrace();
            return null;
        }
    }

    public <T> T getPropertyFromJsonList(String keys) {
        try {
            return (T)this.getProperty(this.toJsonList(), keys);
        }
        catch (JSONException e) {
            e.printStackTrace();
            return null;
        }
    }

    public JSONArray getProperty(JSONArray jsonArray, String keys) throws JSONException {
        JSONArray current = new JSONArray();
        for (int i = 0; i < jsonArray.length() && jsonArray.get(i) instanceof JSONObject; ++i) {
            JSONObject jsonObject = jsonArray.getJSONObject(i);
            Object object = this.getProperty(jsonObject, keys);
            if (object == null) continue;
            current.put(object);
        }
        return current;
    }

    public <T> T getProperty(JSONObject jsonObject, String keys) throws JSONException {
        int i;
        String[] keySet = keys.split("\\.");
        JSONObject current = jsonObject;
        for (i = 0; i < keySet.length - 1; ++i) {
            if (!(jsonObject.get(keySet[i]) instanceof JSONObject)) {
                return null;
            }
            current = jsonObject.getJSONObject(keySet[i]);
        }
        return (T)current.get(keySet[i]);
    }

    public List<Map<String, Object>> toMapList() {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        try {
            for (Object object : this.toObjectList()) {
                if (!(object instanceof Map)) continue;
                list.add((Map)object);
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return list;
    }

    public List<Object> toObjectList() throws JSONException {
        ArrayList<Object> list = new ArrayList<Object>();
        if (this.isJsonObject()) {
            list.add(JSONUtil.getMapFromJSONString((String)this.getJsonResource()));
        }
        if (this.isJsonList()) {
            return JSONUtil.getListFromJSONArray((JSONArray)this.toJsonList());
        }
        return list;
    }

    public Map<String, Object> toObjectMap() throws JSONException {
        if (this.isJsonObject()) {
            return JSONUtil.getMapFromJSONObject((JSONObject)this.toJsonObject());
        }
        return null;
    }

    public List<Map<String, Object>> getMapListForKey(String keys) {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        JSONArray array = this.getPropertyList(keys);
        for (int i = 0; i < array.length(); ++i) {
            try {
                if (!(array.get(i) instanceof JSONObject)) continue;
                list.add(JSONUtil.getMap((JSONObject)array.getJSONObject(i)));
                continue;
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
        return list;
    }
}

