/*
 * Decompiled with CFR 0.152.
 */
package io.github.graphdsl.codegen;

import io.github.graphdsl.codegen.BaseTypeMapper;
import io.github.graphdsl.codegen.FieldParameterModelKt;
import io.github.graphdsl.codegen.InputDslGenKt;
import io.github.graphdsl.codegen.MutationDslGenKt;
import io.github.graphdsl.codegen.MutationFieldDslGenKt;
import io.github.graphdsl.codegen.NodeInterfaceDslGenKt;
import io.github.graphdsl.codegen.ObjectDslGenKt;
import io.github.graphdsl.codegen.QueryDslGenKt;
import io.github.graphdsl.codegen.QueryFieldDslGenKt;
import io.github.graphdsl.schema.GraphDslSchema;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u0000 82\u00020\u0001:\u00018B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ&\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00030\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u001e\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016H\u0002J4\u0010\u0018\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00142\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00030\u000f2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00030\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u001e\u0010\u001a\u001a\u00020\u000b2\u0006\u0010\u001b\u001a\u00020\u00142\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016H\u0002J\u001e\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00140\u001e2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u001f\u001a\u00020\u0003H\u0002J\u000e\u0010 \u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u0011J\u001e\u0010!\u001a\u00020\u000b2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00030#2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0010\u0010$\u001a\u00020\u000b2\u0006\u0010%\u001a\u00020&H\u0002J\u001e\u0010'\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u00112\f\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00030\u000fH\u0002J\u0010\u0010)\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0016\u0010*\u001a\u00020\u000b2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u001eH\u0002J\u0018\u0010+\u001a\u00020\u000b2\u0006\u0010,\u001a\u00020\u00172\u0006\u0010-\u001a\u00020\rH\u0002J\u001e\u0010.\u001a\u00020\u000b2\f\u0010/\u001a\b\u0012\u0004\u0012\u00020\u00030#2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0010\u00100\u001a\u00020\u000b2\u0006\u00101\u001a\u00020\u0014H\u0002J\u0010\u00102\u001a\u00020\u000b2\u0006\u0010\u001b\u001a\u00020\u0014H\u0002J\u0016\u00103\u001a\u00020\u000b2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00170\u001eH\u0002J\u0018\u00104\u001a\u00020\u000b2\u0006\u0010,\u001a\u00020\u00172\u0006\u0010-\u001a\u00020\rH\u0002J\u0010\u00105\u001a\u0002062\u0006\u00107\u001a\u00020\u0003H\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00069"}, d2={"Lio/github/graphdsl/codegen/DslFilesBuilder;", "", "pkg", "", "outputDir", "Ljava/io/File;", "baseTypeMapper", "Lio/github/graphdsl/codegen/BaseTypeMapper;", "(Ljava/lang/String;Ljava/io/File;Lio/github/graphdsl/codegen/BaseTypeMapper;)V", "packageDir", "collectInputTypes", "", "typeDef", "Lio/github/graphdsl/schema/GraphDslSchema$TypeDef;", "inputCollectors", "", "schema", "Lio/github/graphdsl/schema/GraphDslSchema;", "collectMutationFieldsWithInputs", "mutationType", "Lio/github/graphdsl/schema/GraphDslSchema$Object;", "mutationFields", "", "Lio/github/graphdsl/schema/GraphDslSchema$Field;", "collectNeededBuilders", "objectCollectors", "collectQueryFieldsWithInputs", "queryType", "queryFields", "findImplementingTypes", "", "interfaceName", "generate", "generateInputBuilders", "inputTypeNames", "", "generateInputDsl", "inputType", "Lio/github/graphdsl/schema/GraphDslSchema$Input;", "generateInterfaceBuilders", "objectTypesNeedingBuilders", "generateMutationDsl", "generateMutationFieldBuilders", "generateMutationFieldDsl", "field", "returnType", "generateObjectBuilders", "typeNames", "generateObjectDsl", "objectType", "generateQueryDsl", "generateQueryFieldBuilders", "generateQueryFieldDsl", "isRootType", "", "name", "Companion", "codegen"})
@SourceDebugExtension(value={"SMAP\nDslFilesBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DslFilesBuilder.kt\nio/github/graphdsl/codegen/DslFilesBuilder\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,388:1\n1855#2,2:389\n1747#2,3:391\n1747#2,3:394\n800#2,11:397\n766#2:408\n857#2:409\n1747#2,3:410\n858#2:413\n*S KotlinDebug\n*F\n+ 1 DslFilesBuilder.kt\nio/github/graphdsl/codegen/DslFilesBuilder\n*L\n217#1:389,2\n331#1:391,3\n347#1:394,3\n367#1:397,11\n368#1:408\n368#1:409\n368#1:410,3\n368#1:413\n*E\n"})
public final class DslFilesBuilder {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String pkg;
    @NotNull
    private final File outputDir;
    @NotNull
    private final BaseTypeMapper baseTypeMapper;
    @NotNull
    private final File packageDir;
    @NotNull
    private static final String QUERY_TYPE = "Query";
    @NotNull
    private static final String MUTATION_TYPE = "Mutation";
    @NotNull
    private static final Set<String> ROOT_TYPES;

    public DslFilesBuilder(@NotNull String pkg, @NotNull File outputDir, @NotNull BaseTypeMapper baseTypeMapper) {
        Intrinsics.checkNotNullParameter((Object)pkg, (String)"pkg");
        Intrinsics.checkNotNullParameter((Object)outputDir, (String)"outputDir");
        Intrinsics.checkNotNullParameter((Object)baseTypeMapper, (String)"baseTypeMapper");
        this.pkg = pkg;
        this.outputDir = outputDir;
        this.baseTypeMapper = baseTypeMapper;
        this.packageDir = new File(this.outputDir, StringsKt.replace$default((String)this.pkg, (char)'.', (char)'/', (boolean)false, (int)4, null));
    }

    public final void generate(@NotNull GraphDslSchema schema) {
        Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
        this.packageDir.mkdirs();
        Set objectTypesNeedingBuilders = new LinkedHashSet();
        Set inputTypesNeedingBuilders = new LinkedHashSet();
        List queryFieldsNeedingBuilders = new ArrayList();
        List mutationFieldsNeedingBuilders = new ArrayList();
        GraphDslSchema.TypeDef typeDef = (GraphDslSchema.TypeDef)schema.getTypes().get(QUERY_TYPE);
        if (typeDef != null) {
            GraphDslSchema.TypeDef queryType = typeDef;
            boolean bl = false;
            if (queryType instanceof GraphDslSchema.Object) {
                this.generateQueryDsl((GraphDslSchema.Object)queryType);
                this.collectNeededBuilders((GraphDslSchema.Object)queryType, objectTypesNeedingBuilders, inputTypesNeedingBuilders, schema);
                this.collectQueryFieldsWithInputs((GraphDslSchema.Object)queryType, queryFieldsNeedingBuilders);
            }
        }
        GraphDslSchema.TypeDef typeDef2 = (GraphDslSchema.TypeDef)schema.getTypes().get(MUTATION_TYPE);
        if (typeDef2 != null) {
            GraphDslSchema.TypeDef mutationType = typeDef2;
            boolean bl = false;
            if (mutationType instanceof GraphDslSchema.Object) {
                this.generateMutationDsl((GraphDslSchema.Object)mutationType);
                this.collectNeededBuilders((GraphDslSchema.Object)mutationType, objectTypesNeedingBuilders, inputTypesNeedingBuilders, schema);
                this.collectMutationFieldsWithInputs((GraphDslSchema.Object)mutationType, mutationFieldsNeedingBuilders);
            }
        }
        this.generateObjectBuilders(objectTypesNeedingBuilders, schema);
        this.generateInterfaceBuilders(schema, objectTypesNeedingBuilders);
        this.generateInputBuilders(inputTypesNeedingBuilders, schema);
        this.generateQueryFieldBuilders(queryFieldsNeedingBuilders);
        this.generateMutationFieldBuilders(mutationFieldsNeedingBuilders);
    }

    private final void generateQueryDsl(GraphDslSchema.Object queryType) {
        File destination = new File(this.packageDir, "QueryDsl.kt");
        QueryDslGenKt.queryDslGen(this.pkg, queryType, this.baseTypeMapper).write(destination);
    }

    private final void generateMutationDsl(GraphDslSchema.Object mutationType) {
        File destination = new File(this.packageDir, "MutationDsl.kt");
        MutationDslGenKt.mutationDslGen(this.pkg, mutationType, this.baseTypeMapper).write(destination);
    }

    private final void generateObjectDsl(GraphDslSchema.Object objectType) {
        File destination = new File(this.packageDir, objectType.getName() + "DslBuilder.kt");
        ObjectDslGenKt.objectDslGen(this.pkg, objectType, this.baseTypeMapper).write(destination);
    }

    private final void generateInputDsl(GraphDslSchema.Input inputType) {
        File destination = new File(this.packageDir, inputType.getName() + "Builder.kt");
        InputDslGenKt.inputDslGen(this.pkg, inputType, this.baseTypeMapper).write(destination);
    }

    private final void generateMutationFieldDsl(GraphDslSchema.Field field, GraphDslSchema.TypeDef returnType) {
        String builderName = MutationFieldDslGenKt.getMutationFieldBuilderName(field.getName());
        File destination = new File(this.packageDir, builderName + ".kt");
        MutationFieldDslGenKt.mutationFieldDslGen(this.pkg, field, returnType, this.baseTypeMapper).write(destination);
    }

    private final void generateQueryFieldDsl(GraphDslSchema.Field field, GraphDslSchema.TypeDef returnType) {
        String builderName = QueryFieldDslGenKt.getQueryFieldBuilderName(field.getName());
        File destination = new File(this.packageDir, builderName + ".kt");
        QueryFieldDslGenKt.queryFieldDslGen(this.pkg, field, returnType, this.baseTypeMapper).write(destination);
    }

    private final void generateObjectBuilders(Set<String> typeNames, GraphDslSchema schema) {
        for (String typeName : typeNames) {
            GraphDslSchema.TypeDef typeDef = (GraphDslSchema.TypeDef)schema.getTypes().get(typeName);
            if (!(typeDef instanceof GraphDslSchema.Object) || this.isRootType(typeName)) continue;
            this.generateObjectDsl((GraphDslSchema.Object)typeDef);
        }
    }

    private final void generateInterfaceBuilders(GraphDslSchema schema, Set<String> objectTypesNeedingBuilders) {
        for (Map.Entry entry : schema.getTypes().entrySet()) {
            List<GraphDslSchema.Object> implementingTypes;
            String typeName = (String)entry.getKey();
            GraphDslSchema.TypeDef typeDef = (GraphDslSchema.TypeDef)entry.getValue();
            if (!(typeDef instanceof GraphDslSchema.Interface) || !(!((Collection)(implementingTypes = this.findImplementingTypes(schema, typeName))).isEmpty())) continue;
            File destination = new File(this.packageDir, typeName + "DslBuilder.kt");
            NodeInterfaceDslGenKt.nodeInterfaceDslGen(this.pkg, (GraphDslSchema.Interface)typeDef, implementingTypes).write(destination);
            Iterable $this$forEach$iv = implementingTypes;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                GraphDslSchema.Object it = (GraphDslSchema.Object)element$iv;
                boolean bl = false;
                objectTypesNeedingBuilders.add(it.getName());
            }
        }
    }

    private final void generateInputBuilders(Set<String> inputTypeNames, GraphDslSchema schema) {
        for (String typeName : inputTypeNames) {
            GraphDslSchema.TypeDef typeDef = (GraphDslSchema.TypeDef)schema.getTypes().get(typeName);
            if (!(typeDef instanceof GraphDslSchema.Input)) continue;
            this.generateInputDsl((GraphDslSchema.Input)typeDef);
        }
    }

    private final void generateQueryFieldBuilders(List<? extends GraphDslSchema.Field> queryFields) {
        for (GraphDslSchema.Field field : queryFields) {
            GraphDslSchema.TypeDef returnType = field.getType().getBaseTypeDef();
            if (!FieldParameterModelKt.requiresSelectionSet(returnType)) continue;
            this.generateQueryFieldDsl(field, returnType);
        }
    }

    private final void generateMutationFieldBuilders(List<? extends GraphDslSchema.Field> mutationFields) {
        for (GraphDslSchema.Field field : mutationFields) {
            GraphDslSchema.TypeDef returnType = field.getType().getBaseTypeDef();
            if (!FieldParameterModelKt.requiresSelectionSet(returnType)) continue;
            this.generateMutationFieldDsl(field, returnType);
        }
    }

    private final void collectNeededBuilders(GraphDslSchema.Object typeDef, Set<String> objectCollectors, Set<String> inputCollectors, GraphDslSchema schema) {
        for (GraphDslSchema.Field field : typeDef.getFields()) {
            for (GraphDslSchema.FieldArg arg : field.getArgs()) {
                this.collectInputTypes(arg.getType().getBaseTypeDef(), inputCollectors, schema);
            }
            GraphDslSchema.TypeDef returnType = field.getType().getBaseTypeDef();
            if (returnType instanceof GraphDslSchema.Object) {
                if (this.isRootType(returnType.getName()) || !objectCollectors.add(returnType.getName())) continue;
                this.collectNeededBuilders((GraphDslSchema.Object)returnType, objectCollectors, inputCollectors, schema);
                continue;
            }
            if (!(returnType instanceof GraphDslSchema.Interface ? true : returnType instanceof GraphDslSchema.Union)) continue;
            objectCollectors.add(returnType.getName());
        }
    }

    private final void collectInputTypes(GraphDslSchema.TypeDef typeDef, Set<String> inputCollectors, GraphDslSchema schema) {
        if (typeDef instanceof GraphDslSchema.Input && inputCollectors.add(typeDef.getName())) {
            for (GraphDslSchema.Field field : ((GraphDslSchema.Input)typeDef).getFields()) {
                this.collectInputTypes(field.getType().getBaseTypeDef(), inputCollectors, schema);
            }
        }
    }

    private final void collectQueryFieldsWithInputs(GraphDslSchema.Object queryType, List<GraphDslSchema.Field> queryFields) {
        for (GraphDslSchema.Field field : queryType.getFields()) {
            boolean bl;
            block4: {
                Iterable $this$any$iv = field.getArgs();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        GraphDslSchema.FieldArg it = (GraphDslSchema.FieldArg)element$iv;
                        boolean bl2 = false;
                        if (!(it.getType().getBaseTypeDef() instanceof GraphDslSchema.Input)) continue;
                        bl = true;
                        break block4;
                    }
                    bl = false;
                }
            }
            boolean hasInputArgs = bl;
            boolean hasComplexReturnType = FieldParameterModelKt.requiresSelectionSet(field.getType().getBaseTypeDef());
            if (!hasInputArgs || !hasComplexReturnType) continue;
            queryFields.add(field);
        }
    }

    private final void collectMutationFieldsWithInputs(GraphDslSchema.Object mutationType, List<GraphDslSchema.Field> mutationFields) {
        for (GraphDslSchema.Field field : mutationType.getFields()) {
            boolean bl;
            block4: {
                Iterable $this$any$iv = field.getArgs();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        GraphDslSchema.FieldArg it = (GraphDslSchema.FieldArg)element$iv;
                        boolean bl2 = false;
                        if (!(it.getType().getBaseTypeDef() instanceof GraphDslSchema.Input)) continue;
                        bl = true;
                        break block4;
                    }
                    bl = false;
                }
            }
            boolean hasInputArgs = bl;
            boolean hasComplexReturnType = FieldParameterModelKt.requiresSelectionSet(field.getType().getBaseTypeDef());
            if (!hasInputArgs || !hasComplexReturnType) continue;
            mutationFields.add(field);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final List<GraphDslSchema.Object> findImplementingTypes(GraphDslSchema schema, String interfaceName) {
        void $this$filterTo$iv$iv;
        Iterable $this$filterIsInstanceTo$iv$iv;
        Iterable $this$filterIsInstance$iv = schema.getTypes().values();
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof GraphDslSchema.Object)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$filterIsInstanceTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            boolean bl;
            block5: {
                GraphDslSchema.Object obj = (GraphDslSchema.Object)element$iv$iv;
                boolean bl2 = false;
                Iterable $this$any$iv = obj.getSupers();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        GraphDslSchema.Interface it = (GraphDslSchema.Interface)element$iv;
                        boolean bl3 = false;
                        if (!Intrinsics.areEqual((Object)it.getName(), (Object)interfaceName)) continue;
                        bl = true;
                        break block5;
                    }
                    bl = false;
                }
            }
            if (!bl) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final boolean isRootType(String name) {
        return ROOT_TYPES.contains(name);
    }

    static {
        Object[] objectArray = new String[]{QUERY_TYPE, MUTATION_TYPE, "Subscription"};
        ROOT_TYPES = SetsKt.setOf((Object[])objectArray);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\"\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00040\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lio/github/graphdsl/codegen/DslFilesBuilder$Companion;", "", "()V", "MUTATION_TYPE", "", "QUERY_TYPE", "ROOT_TYPES", "", "codegen"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

