/*
 * Decompiled with CFR 0.152.
 */
package io.github.graphdsl.utils;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0016\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u0000 \u001b2\u00020\u0001:\u0002\u001a\u001bB\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B#\b\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0003H\u0002J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u0003H\u0002J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\u000e\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\u0003J\u0016\u0010\u0014\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u0003J\b\u0010\u0015\u001a\u00020\u0003H\u0016J\u0006\u0010\u0016\u001a\u00020\u0000J\u000e\u0010\u0017\u001a\u00020\u00002\u0006\u0010\u000f\u001a\u00020\u0003J\b\u0010\u0018\u001a\u00020\u0019H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u001c"}, d2={"Lio/github/graphdsl/utils/BitVector;", "", "vSize", "", "(I)V", "size", "bits", "", "extraBits", "", "(IJ[J)V", "getSize", "()I", "check", "", "idx", "count", "equals", "", "other", "get", "hashCode", "lsr", "set", "toString", "", "Builder", "Companion", "utils"})
@SourceDebugExtension(value={"SMAP\nBitVector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BitVector.kt\nio/github/graphdsl/utils/BitVector\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,215:1\n1#2:216\n*E\n"})
public final class BitVector {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int size;
    private long bits;
    @Nullable
    private long[] extraBits;

    private BitVector(int size, long bits, long[] extraBits) {
        this.size = size;
        this.bits = bits;
        this.extraBits = extraBits;
    }

    /* synthetic */ BitVector(int n, long l, long[] lArray, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 4) != 0) {
            lArray = null;
        }
        this(n, l, lArray);
    }

    public final int getSize() {
        return this.size;
    }

    public BitVector(int vSize) {
        this(0 <= vSize ? vSize : -vSize, BitVector.Companion.fragment(vSize), null, 4, null);
        int len;
        int size = vSize;
        int n = len = 0 <= size ? size : -size;
        if (len <= 64) {
            this.extraBits = null;
        } else {
            int l = (len - 1) / 64;
            this.extraBits = new long[l];
            if (size < 0) {
                int n2 = l - 1;
                for (int i = 0; i < n2; ++i) {
                    Intrinsics.checkNotNull((Object)this.extraBits);
                    this.extraBits[i] = -1L;
                    size += 64;
                }
                Intrinsics.checkNotNull((Object)this.extraBits);
                this.extraBits[l - 1] = BitVector.Companion.fragment(size + 64);
            }
        }
    }

    private final void check(int idx) {
        if (!(0 <= idx ? idx < this.size : false)) {
            throw new IndexOutOfBoundsException("" + idx);
        }
    }

    private final void check(int idx, int count) {
        if (idx < 0) {
            throw new IndexOutOfBoundsException("" + idx);
        }
        if (count < 0) {
            throw new IllegalArgumentException("" + this.size);
        }
        if (this.size < idx + count) {
            throw new IndexOutOfBoundsException(idx + "+" + count);
        }
        if (!(0 <= count ? count < 65 : false)) {
            boolean bl = false;
            String string = "" + count;
            throw new IllegalArgumentException(string.toString());
        }
    }

    public final boolean get(int idx) {
        long l;
        this.check(idx);
        if (idx < 64) {
            l = this.bits;
        } else {
            Intrinsics.checkNotNull((Object)this.extraBits);
            l = this.extraBits[(idx >> 6) - 1];
        }
        long result = l;
        return 0L != (result & 1L << (idx & 0x3F));
    }

    public final long get(int idx, int count) {
        long l;
        this.check(idx, count);
        if (count == 0) {
            return 0L;
        }
        if (idx < 64) {
            l = this.bits;
        } else {
            Intrinsics.checkNotNull((Object)this.extraBits);
            l = this.extraBits[(idx >> 6) - 1];
        }
        long result = l;
        int startingBitInLo = idx & 0x3F;
        long mask = count == 64 ? -1L : (1L << count) - 1L;
        result = result >>> startingBitInLo & mask;
        if (64 < count + (idx & 0x3F)) {
            int hi = idx - 64 + count - 1 >> 6;
            int countInLo = 64 - startingBitInLo;
            int countInHi = count - countInLo;
            long hiMask = countInHi == 64 ? -1L : (1L << countInHi) - 1L;
            Intrinsics.checkNotNull((Object)this.extraBits);
            result |= (this.extraBits[hi] & hiMask) << countInLo;
        }
        return result;
    }

    @NotNull
    public final BitVector set(int idx) {
        this.check(idx);
        if (idx < 64) {
            this.bits |= 1L << (idx & 0x3F);
        } else {
            Intrinsics.checkNotNull((Object)this.extraBits);
            Intrinsics.checkNotNull((Object)this.extraBits);
            this.extraBits[(idx >> 6) - 1] = this.extraBits[(idx >> 6) - 1] | 1L << (idx & 0x3F);
        }
        return this;
    }

    @NotNull
    public final BitVector lsr() {
        if (this.size == 0) {
            return this;
        }
        long newBits = this.bits >>> 1;
        if (64 < this.size) {
            Intrinsics.checkNotNull((Object)this.extraBits);
            newBits |= this.extraBits[0] << 63;
        }
        long[] newExtraBits = null;
        int extraBitsLen = (this.size - 2) / 64;
        if (0 < extraBitsLen) {
            newExtraBits = new long[extraBitsLen];
            for (int i = 0; i < extraBitsLen; ++i) {
                Intrinsics.checkNotNull((Object)this.extraBits);
                newExtraBits[i] = this.extraBits[i] >>> 1;
                Intrinsics.checkNotNull((Object)this.extraBits);
                if (i + 1 >= this.extraBits.length) continue;
                long l = newExtraBits[i];
                Intrinsics.checkNotNull((Object)this.extraBits);
                newExtraBits[i] = l | this.extraBits[i + 1] << 63;
            }
        }
        return new BitVector(this.size - 1, newBits, newExtraBits);
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof BitVector)) {
            return false;
        }
        if (this.size != ((BitVector)other).size) {
            return false;
        }
        if (this.bits != ((BitVector)other).bits) {
            return false;
        }
        if (64 < this.size) {
            int len = (this.size - 1) / 64;
            for (int i = 0; i < len; ++i) {
                Intrinsics.checkNotNull((Object)this.extraBits);
                long l = this.extraBits[i];
                Intrinsics.checkNotNull((Object)((BitVector)other).extraBits);
                if (l == ((BitVector)other).extraBits[i]) continue;
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        int result = 31 + (int)(this.bits ^ this.bits >>> 32);
        if (64 < this.size) {
            int len = (this.size - 1) / 64;
            for (int i = 0; i < len; ++i) {
                Intrinsics.checkNotNull((Object)this.extraBits);
                long element = this.extraBits[i];
                int elementHash = (int)(element ^ element >>> 32);
                result = 31 * result + elementHash;
            }
        }
        return result;
    }

    @NotNull
    public String toString() {
        StringBuilder result = new StringBuilder();
        for (int i = this.size - 1; 0 <= i; --i) {
            result.append(this.get(i) ? (char)'1' : '0');
        }
        String string = result.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"result.toString()");
        return string;
    }

    public /* synthetic */ BitVector(int size, long bits, long[] extraBits, DefaultConstructorMarker $constructor_marker) {
        this(size, bits, extraBits);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0016\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\n\u001a\u00020\u00002\u0006\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\u0004J\u0006\u0010\r\u001a\u00020\u000eJ\b\u0010\u000f\u001a\u00020\u0010H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lio/github/graphdsl/utils/BitVector$Builder;", "", "()V", "bitsInBuffer", "", "buffer", "", "inserted", "", "insertedSize", "add", "bits", "count", "build", "Lio/github/graphdsl/utils/BitVector;", "pushBuffer", "", "utils"})
    @SourceDebugExtension(value={"SMAP\nBitVector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BitVector.kt\nio/github/graphdsl/utils/BitVector$Builder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,215:1\n1#2:216\n*E\n"})
    public static final class Builder {
        @Nullable
        private long[] inserted = new long[4];
        private int insertedSize;
        private long buffer;
        private int bitsInBuffer;

        private final void pushBuffer() {
            Intrinsics.checkNotNull((Object)this.inserted);
            if (this.insertedSize == this.inserted.length) {
                Intrinsics.checkNotNull((Object)this.inserted);
                int newCapacity = Math.max(8, this.inserted.length * 2);
                long[] tmp = new long[newCapacity];
                Intrinsics.checkNotNull((Object)this.inserted);
                System.arraycopy(this.inserted, 0, tmp, 0, this.insertedSize);
                this.inserted = tmp;
            }
            Intrinsics.checkNotNull((Object)this.inserted);
            this.inserted[this.insertedSize] = this.buffer;
            int n = this.insertedSize;
            this.insertedSize = n + 1;
            this.buffer = 0L;
            this.bitsInBuffer = 0;
        }

        @NotNull
        public final Builder add(long bits, int count) {
            long[] lArray = this.inserted;
            if (this.inserted == null) {
                boolean $i$a$-checkNotNull-BitVector$Builder$add$22 = false;
                String $i$a$-checkNotNull-BitVector$Builder$add$22 = "Builder has already been built.";
                throw new IllegalStateException($i$a$-checkNotNull-BitVector$Builder$add$22.toString());
            }
            if (!(0 <= count ? count < 65 : false)) {
                boolean $i$a$-require-BitVector$Builder$add$32 = false;
                String $i$a$-require-BitVector$Builder$add$32 = "Bad count arg (" + count + ").";
                throw new IllegalArgumentException($i$a$-require-BitVector$Builder$add$32.toString());
            }
            if (count == 0) {
                return this;
            }
            int firstInsertCount = (int)Math.min((double)(64 - this.bitsInBuffer), (double)count);
            long mask = firstInsertCount == 64 ? -1L : (1L << firstInsertCount) - 1L;
            this.buffer |= (bits & mask) << this.bitsInBuffer;
            this.bitsInBuffer += firstInsertCount;
            if (this.bitsInBuffer == 64) {
                this.pushBuffer();
            }
            if (firstInsertCount < count) {
                int secondInsertCount = count - firstInsertCount;
                this.buffer |= bits >>> firstInsertCount & (1L << secondInsertCount) - 1L;
                this.bitsInBuffer += secondInsertCount;
            }
            return this;
        }

        @NotNull
        public final BitVector build() {
            long[] lArray = this.inserted;
            if (this.inserted == null) {
                boolean $i$a$-checkNotNull-BitVector$Builder$build$22 = false;
                String $i$a$-checkNotNull-BitVector$Builder$build$22 = "Builder has already been built.";
                throw new IllegalStateException($i$a$-checkNotNull-BitVector$Builder$build$22.toString());
            }
            int size = this.bitsInBuffer + 64 * this.insertedSize;
            long bits = 0L;
            long[] extraBits = null;
            if (size <= 64) {
                long l;
                if (size < 64) {
                    l = this.buffer;
                } else {
                    Intrinsics.checkNotNull((Object)this.inserted);
                    l = this.inserted[0];
                }
                bits = l;
                extraBits = null;
            } else {
                Intrinsics.checkNotNull((Object)this.inserted);
                bits = this.inserted[0];
                int finalSize = this.bitsInBuffer > 0 ? this.insertedSize : this.insertedSize - 1;
                long[] result = new long[finalSize];
                Intrinsics.checkNotNull((Object)this.inserted);
                System.arraycopy(this.inserted, 1, result, 0, this.insertedSize - 1);
                if (this.bitsInBuffer > 0) {
                    result[finalSize - 1] = this.buffer;
                }
                extraBits = result;
            }
            this.inserted = null;
            return new BitVector(size, bits, extraBits, null);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u00a8\u0006\u0007"}, d2={"Lio/github/graphdsl/utils/BitVector$Companion;", "", "()V", "fragment", "", "size", "", "utils"})
    public static final class Companion {
        private Companion() {
        }

        private final long fragment(int size) {
            if (0 <= size) {
                return 0L;
            }
            if (size <= -64) {
                return -1L;
            }
            return 0xFFFFFFFFFFFFFFFFL & (1L << -size) - 1L;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

