/*
 * Decompiled with CFR 0.152.
 */
package name.martingeisse.grumpyjson;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import name.martingeisse.grumpyjson.util.StringUtil;

public abstract class FieldErrorNode {
    private FieldErrorNode() {
    }

    public static FieldErrorNode create(String message) {
        return new Message(message);
    }

    public static FieldErrorNode create(Exception exception) {
        return new InternalException(exception);
    }

    public final FieldErrorNode and(FieldErrorNode other) {
        return other == null ? this : new Siblings(this, other);
    }

    public final FieldErrorNode in(String fieldName) {
        Objects.requireNonNull(fieldName, "fieldName");
        return new Field(fieldName, this);
    }

    public final List<FlattenedError> flatten() {
        ArrayList<FlattenedError> errors = new ArrayList<FlattenedError>();
        ArrayList<String> segments = new ArrayList<String>();
        this.flatten(errors, segments);
        return List.copyOf(errors);
    }

    protected abstract void flatten(List<FlattenedError> var1, List<String> var2);

    public String toString() {
        return StringUtil.join(this.flatten(), "; ");
    }

    public static final class Message
    extends FieldErrorNode {
        private final String message;

        private Message(String message) {
            Objects.requireNonNull(message, "message");
            this.message = message;
        }

        public String getMessage() {
            return this.message;
        }

        @Override
        protected void flatten(List<FlattenedError> errors, List<String> segments) {
            Objects.requireNonNull(errors, "errors");
            Objects.requireNonNull(segments, "segments");
            errors.add(new FlattenedError(this.message, segments));
        }
    }

    public static final class InternalException
    extends FieldErrorNode {
        private final Exception exception;

        private InternalException(Exception exception) {
            Objects.requireNonNull(exception, "exception");
            this.exception = exception;
        }

        public Exception getException() {
            return this.exception;
        }

        @Override
        protected void flatten(List<FlattenedError> errors, List<String> segments) {
            Objects.requireNonNull(errors, "errors");
            Objects.requireNonNull(segments, "segments");
            errors.add(new FlattenedError("internal error", segments));
        }
    }

    public static final class Siblings
    extends FieldErrorNode {
        private final FieldErrorNode first;
        private final FieldErrorNode second;

        private Siblings(FieldErrorNode first, FieldErrorNode second) {
            Objects.requireNonNull(first, "first");
            Objects.requireNonNull(second, "second");
            this.first = first;
            this.second = second;
        }

        public FieldErrorNode getFirst() {
            return this.first;
        }

        public FieldErrorNode getSecond() {
            return this.second;
        }

        @Override
        protected void flatten(List<FlattenedError> errors, List<String> segments) {
            Objects.requireNonNull(errors, "errors");
            Objects.requireNonNull(segments, "segments");
            this.first.flatten(errors, segments);
            this.second.flatten(errors, segments);
        }
    }

    public static final class Field
    extends FieldErrorNode {
        private final String name;
        private final FieldErrorNode node;

        private Field(String name, FieldErrorNode node) {
            Objects.requireNonNull(name, "name");
            Objects.requireNonNull(node, "node");
            this.name = name;
            this.node = node;
        }

        public String getName() {
            return this.name;
        }

        public FieldErrorNode getNode() {
            return this.node;
        }

        @Override
        protected void flatten(List<FlattenedError> errors, List<String> segments) {
            Objects.requireNonNull(errors, "errors");
            Objects.requireNonNull(segments, "segments");
            segments.add(this.name);
            this.node.flatten(errors, segments);
            segments.remove(segments.size() - 1);
        }
    }

    public record FlattenedError(String message, List<String> fieldPath) {
        public FlattenedError {
            Objects.requireNonNull(message, "message");
            Objects.requireNonNull(fieldPath, "fieldPath");
            fieldPath = List.copyOf(fieldPath);
        }

        public FlattenedError(String message, String ... pathSegments) {
            this(message, List.of(pathSegments));
        }

        public String getPathAsString() {
            return this.fieldPath.isEmpty() ? "(root)" : StringUtil.join(this.fieldPath, ".");
        }

        @Override
        public String toString() {
            return "at field " + this.getPathAsString() + ": " + this.message;
        }
    }
}

