/*
 * Decompiled with CFR 0.152.
 */
package name.martingeisse.grumpyjson.builtin;

import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import java.lang.reflect.Type;
import java.util.Objects;
import name.martingeisse.grumpyjson.deserialize.JsonDeserializationException;
import name.martingeisse.grumpyjson.deserialize.JsonDeserializer;
import name.martingeisse.grumpyjson.serialize.JsonSerializationException;
import name.martingeisse.grumpyjson.serialize.JsonSerializer;

public final class EnumConverter<T extends Enum<T>>
implements JsonSerializer<T>,
JsonDeserializer {
    private final Class<T> enumClass;

    public EnumConverter(Class<T> enumClass) {
        Objects.requireNonNull(enumClass, "enumClass");
        this.enumClass = enumClass;
    }

    @Override
    public boolean supportsTypeForDeserialization(Type type) {
        Objects.requireNonNull(type, "type");
        return type.equals(this.enumClass);
    }

    @Override
    public Object deserialize(JsonElement json, Type type) throws JsonDeserializationException {
        JsonPrimitive primitive;
        Objects.requireNonNull(json, "json");
        Objects.requireNonNull(type, "type");
        if (!(json instanceof JsonPrimitive) || !(primitive = (JsonPrimitive)json).isString()) {
            throw new JsonDeserializationException("expected string, found: " + String.valueOf(json));
        }
        try {
            return Enum.valueOf(this.enumClass, primitive.getAsString());
        }
        catch (IllegalArgumentException e) {
            throw new JsonDeserializationException("unknown value: " + primitive.getAsString());
        }
    }

    @Override
    public boolean supportsClassForSerialization(Class<?> clazz) {
        Objects.requireNonNull(clazz, "clazz");
        return clazz.equals(this.enumClass);
    }

    @Override
    public JsonElement serialize(T value) throws JsonSerializationException {
        Objects.requireNonNull(value, "value");
        return new JsonPrimitive(((Enum)value).name());
    }
}

