/*
 * Decompiled with CFR 0.152.
 */
package name.martingeisse.grumpyjson.builtin;

import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import java.lang.reflect.Type;
import java.util.Objects;
import name.martingeisse.grumpyjson.builtin.IntegralNumberDeserializationUtil;
import name.martingeisse.grumpyjson.deserialize.JsonDeserializationException;
import name.martingeisse.grumpyjson.deserialize.JsonDeserializer;
import name.martingeisse.grumpyjson.serialize.JsonSerializationException;
import name.martingeisse.grumpyjson.serialize.JsonSerializer;

public final class IntegerConverter
implements JsonSerializer<Integer>,
JsonDeserializer {
    @Override
    public boolean supportsTypeForDeserialization(Type type) {
        Objects.requireNonNull(type, "type");
        return type.equals(Integer.TYPE) || type.equals(Integer.class);
    }

    @Override
    public Integer deserialize(JsonElement json, Type type) throws JsonDeserializationException {
        JsonPrimitive primitive;
        Objects.requireNonNull(json, "json");
        Objects.requireNonNull(type, "type");
        if (json instanceof JsonPrimitive && (primitive = (JsonPrimitive)json).isNumber()) {
            long longValue = IntegralNumberDeserializationUtil.deserialize(primitive.getAsNumber());
            int intValue = (int)longValue;
            IntegralNumberDeserializationUtil.verifyBounds(longValue, intValue);
            return intValue;
        }
        throw new JsonDeserializationException("expected integer, found: " + String.valueOf(json));
    }

    @Override
    public boolean supportsClassForSerialization(Class<?> clazz) {
        Objects.requireNonNull(clazz, "clazz");
        return clazz.equals(Integer.TYPE) || clazz.equals(Integer.class);
    }

    @Override
    public JsonElement serialize(Integer value) throws JsonSerializationException {
        Objects.requireNonNull(value, "value");
        return new JsonPrimitive((Number)value);
    }
}

