/*
 * Decompiled with CFR 0.152.
 */
package name.martingeisse.grumpyjson.builtin;

import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import java.lang.reflect.Type;
import java.util.Objects;
import name.martingeisse.grumpyjson.builtin.IntegralNumberDeserializationUtil;
import name.martingeisse.grumpyjson.deserialize.JsonDeserializationException;
import name.martingeisse.grumpyjson.deserialize.JsonDeserializer;
import name.martingeisse.grumpyjson.serialize.JsonSerializationException;
import name.martingeisse.grumpyjson.serialize.JsonSerializer;

public final class LongConverter
implements JsonSerializer<Long>,
JsonDeserializer {
    @Override
    public boolean supportsTypeForDeserialization(Type type) {
        Objects.requireNonNull(type, "type");
        return type.equals(Long.TYPE) || type.equals(Long.class);
    }

    @Override
    public Long deserialize(JsonElement json, Type type) throws JsonDeserializationException {
        JsonPrimitive primitive;
        Objects.requireNonNull(json, "json");
        Objects.requireNonNull(type, "type");
        if (json instanceof JsonPrimitive && (primitive = (JsonPrimitive)json).isNumber()) {
            return IntegralNumberDeserializationUtil.deserialize(primitive.getAsNumber());
        }
        throw new JsonDeserializationException("expected long (64-bit integer), found: " + String.valueOf(json));
    }

    @Override
    public boolean supportsClassForSerialization(Class<?> clazz) {
        Objects.requireNonNull(clazz, "clazz");
        return clazz.equals(Long.TYPE) || clazz.equals(Long.class);
    }

    @Override
    public JsonElement serialize(Long value) throws JsonSerializationException {
        Objects.requireNonNull(value, "value");
        return new JsonPrimitive((Number)value);
    }
}

