/*
 * Decompiled with CFR 0.152.
 */
package name.martingeisse.grumpyjson.builtin.helper_types;

import java.util.Objects;
import java.util.function.Supplier;

public final class NullableField<T> {
    private final T value;

    private NullableField(T value) {
        this.value = value;
    }

    public static <T> NullableField<T> ofValue(T value) {
        return new NullableField<T>(Objects.requireNonNull(value, "value"));
    }

    public static <T> NullableField<T> ofNull() {
        return new NullableField<Object>(null);
    }

    public static <T> NullableField<T> ofValueOrNull(T value) {
        return new NullableField<T>(value);
    }

    public T getValueOrNull() {
        return this.value;
    }

    public T getValue() {
        if (this.value == null) {
            throw new IllegalStateException("this NullableField is null");
        }
        return this.value;
    }

    public boolean isNonNull() {
        return this.value != null;
    }

    public boolean isNull() {
        return this.value == null;
    }

    public T orElse(T other) {
        return this.value == null ? other : this.value;
    }

    public T orElseGet(Supplier<T> other) {
        Objects.requireNonNull(other, "other");
        return this.value == null ? other.get() : this.value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NullableField that = (NullableField)o;
        return Objects.equals(this.value, that.value);
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public String toString() {
        return "NullableField{value=" + String.valueOf(this.value) + "}";
    }
}

