/*
 * Decompiled with CFR 0.152.
 */
package name.martingeisse.grumpyjson.builtin.helper_types;

import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import java.lang.reflect.Type;
import java.util.Objects;
import name.martingeisse.grumpyjson.JsonRegistries;
import name.martingeisse.grumpyjson.builtin.helper_types.NullableField;
import name.martingeisse.grumpyjson.deserialize.JsonDeserializationException;
import name.martingeisse.grumpyjson.deserialize.JsonDeserializer;
import name.martingeisse.grumpyjson.serialize.JsonSerializationException;
import name.martingeisse.grumpyjson.serialize.JsonSerializer;
import name.martingeisse.grumpyjson.util.TypeUtil;

public final class NullableFieldConverter
implements JsonSerializer<NullableField<?>>,
JsonDeserializer {
    private final JsonRegistries registries;

    public NullableFieldConverter(JsonRegistries registries) {
        Objects.requireNonNull(registries, "registries");
        this.registries = registries;
    }

    @Override
    public boolean supportsTypeForDeserialization(Type type) {
        Objects.requireNonNull(type, "type");
        return TypeUtil.isSingleParameterizedType(type, NullableField.class) != null;
    }

    @Override
    public NullableField<?> deserialize(JsonElement json, Type type) throws JsonDeserializationException {
        Objects.requireNonNull(json, "json");
        Objects.requireNonNull(type, "type");
        Type innerType = TypeUtil.expectSingleParameterizedType(type, NullableField.class);
        if (json.isJsonNull()) {
            return NullableField.ofNull();
        }
        try {
            return NullableField.ofValue(this.registries.deserialize(json, innerType));
        }
        catch (Exception e) {
            throw new JsonDeserializationException(e);
        }
    }

    @Override
    public boolean supportsClassForSerialization(Class<?> clazz) {
        Objects.requireNonNull(clazz, "clazz");
        return clazz.equals(NullableField.class);
    }

    @Override
    public JsonElement serialize(NullableField<?> value) throws JsonSerializationException {
        Objects.requireNonNull(value, "value");
        if (value.isNull()) {
            return JsonNull.INSTANCE;
        }
        try {
            return this.registries.serialize(value.getValueOrNull());
        }
        catch (Exception e) {
            throw new JsonSerializationException(e);
        }
    }
}

