/*
 * Decompiled with CFR 0.152.
 */
package name.martingeisse.grumpyjson.builtin.record;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import name.martingeisse.grumpyjson.FieldErrorNode;
import name.martingeisse.grumpyjson.JsonRegistries;
import name.martingeisse.grumpyjson.builtin.record.RecordInfo;
import name.martingeisse.grumpyjson.deserialize.JsonDeserializationException;
import name.martingeisse.grumpyjson.deserialize.JsonDeserializer;
import name.martingeisse.grumpyjson.serialize.JsonSerializationException;
import name.martingeisse.grumpyjson.serialize.JsonSerializer;

public final class RecordConverter<T>
implements JsonSerializer<T>,
JsonDeserializer {
    private final RecordInfo recordInfo;
    private final JsonRegistries registries;
    private final Options options;

    public RecordConverter(Class<T> clazz, JsonRegistries registries) {
        this(clazz, registries, new Options(false));
    }

    public RecordConverter(Class<T> clazz, JsonRegistries registries, Options options) {
        Objects.requireNonNull(clazz, "clazz");
        Objects.requireNonNull(registries, "registries");
        Objects.requireNonNull(options, "options");
        this.recordInfo = new RecordInfo(clazz);
        this.registries = registries;
        this.options = options;
    }

    @Override
    public boolean supportsTypeForDeserialization(Type type) {
        ParameterizedType p;
        Objects.requireNonNull(type, "type");
        if (type instanceof Class) {
            return type.equals(this.recordInfo.getRecordClass());
        }
        if (type instanceof ParameterizedType && (p = (ParameterizedType)type).getRawType() instanceof Class) {
            return p.getRawType().equals(this.recordInfo.getRecordClass());
        }
        return false;
    }

    public T deserialize(JsonElement json, Type recordType) throws JsonDeserializationException {
        Objects.requireNonNull(json, "json");
        Objects.requireNonNull(recordType, "recordType");
        if (json instanceof JsonObject) {
            JsonObject jsonObject = (JsonObject)json;
            List<RecordInfo.ComponentInfo> componentInfos = this.recordInfo.getComponentInfos();
            int numberOfPresentKnownProperties = 0;
            Object[] fieldValues = new Object[componentInfos.size()];
            FieldErrorNode errorNode = null;
            for (int i = 0; i < componentInfos.size(); ++i) {
                RecordInfo.ComponentInfo componentInfo = componentInfos.get(i);
                String name = componentInfo.getName();
                JsonElement propertyJson = jsonObject.get(name);
                if (propertyJson != null) {
                    ++numberOfPresentKnownProperties;
                }
                try {
                    Type concreteFieldType = componentInfo.getConcreteType(recordType);
                    JsonDeserializer deserializer = this.registries.getDeserializer(concreteFieldType);
                    if (propertyJson == null) {
                        fieldValues[i] = deserializer.deserializeAbsent(concreteFieldType);
                        continue;
                    }
                    fieldValues[i] = deserializer.deserialize(propertyJson, concreteFieldType);
                    continue;
                }
                catch (JsonDeserializationException e) {
                    errorNode = e.getFieldErrorNode().in(name).and(errorNode);
                    continue;
                }
                catch (Exception e) {
                    errorNode = FieldErrorNode.create(e).in(name).and(errorNode);
                }
            }
            if (!this.options.ignoreUnknownProperties() && numberOfPresentKnownProperties != jsonObject.size()) {
                HashSet propertyNames = new HashSet(jsonObject.keySet());
                for (RecordInfo.ComponentInfo componentInfo : componentInfos) {
                    propertyNames.remove(componentInfo.getName());
                }
                for (String unexpectedProperty : propertyNames) {
                    errorNode = FieldErrorNode.create("unexpected property").in(unexpectedProperty).and(errorNode);
                }
            }
            if (errorNode != null) {
                throw new JsonDeserializationException(errorNode);
            }
            return (T)this.recordInfo.invokeConstructor(fieldValues);
        }
        throw new JsonDeserializationException("expected object, found: " + String.valueOf(json));
    }

    @Override
    public boolean supportsClassForSerialization(Class<?> clazz) {
        Objects.requireNonNull(clazz, "clazz");
        return clazz.equals(this.recordInfo.getRecordClass());
    }

    @Override
    public JsonElement serialize(T record) {
        Objects.requireNonNull(record, "value");
        JsonObject jsonObject = new JsonObject();
        FieldErrorNode errorNode = null;
        for (RecordInfo.ComponentInfo componentInfo : this.recordInfo.getComponentInfos()) {
            String name = componentInfo.getName();
            try {
                Object value = componentInfo.invokeGetter(record);
                if (value == null) {
                    throw new JsonSerializationException("field is null");
                }
                Optional<JsonElement> optionalJson = this.registries.serializeOptional(value);
                optionalJson.ifPresent(jsonElement -> jsonObject.add(name, jsonElement));
            }
            catch (JsonSerializationException e) {
                errorNode = e.getFieldErrorNode().in(name).and(errorNode);
            }
            catch (Exception e) {
                errorNode = FieldErrorNode.create(e).in(name).and(errorNode);
            }
        }
        if (errorNode != null) {
            throw new JsonSerializationException(errorNode);
        }
        return jsonObject;
    }

    public record Options(boolean ignoreUnknownProperties) {
    }
}

