/*
 * Decompiled with CFR 0.152.
 */
package name.martingeisse.grumpyjson.deserialize;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Objects;
import name.martingeisse.grumpyjson.builtin.EnumConverter;
import name.martingeisse.grumpyjson.builtin.record.RecordConverterFactory;
import name.martingeisse.grumpyjson.deserialize.JsonDeserializer;
import name.martingeisse.grumpyjson.deserialize.JsonDeserializerProvider;
import name.martingeisse.grumpyjson.registry.NotRegisteredException;
import name.martingeisse.grumpyjson.registry.Registry;

public final class JsonDeserializerRegistry
extends Registry<Type, JsonDeserializer>
implements JsonDeserializerProvider {
    private final RecordConverterFactory recordConverterFactory;

    public JsonDeserializerRegistry(RecordConverterFactory recordConverterFactory) {
        Objects.requireNonNull(recordConverterFactory, "recordConverterFactory");
        this.recordConverterFactory = recordConverterFactory;
    }

    @Override
    protected boolean registrableSupports(JsonDeserializer registrable, Type key) {
        Objects.requireNonNull(registrable, "registrable");
        Objects.requireNonNull(key, "key");
        return registrable.supportsTypeForDeserialization(key);
    }

    @Override
    protected JsonDeserializer generateRegistrable(Type type) {
        ParameterizedType p;
        Type type2;
        Class rawClass;
        Objects.requireNonNull(type, "type");
        if (type instanceof Class) {
            Class c;
            rawClass = c = (Class)type;
        } else if (type instanceof ParameterizedType && (type2 = (p = (ParameterizedType)type).getRawType()) instanceof Class) {
            Class c;
            rawClass = c = (Class)type2;
        } else {
            return null;
        }
        if (rawClass.isRecord()) {
            return this.recordConverterFactory.getDeserializer(rawClass);
        }
        if (rawClass.isEnum()) {
            return new EnumConverter(rawClass);
        }
        return null;
    }

    @Override
    protected String getErrorMessageForUnknownKey(Type type) {
        Objects.requireNonNull(type, "type");
        return "no JSON deserializer found and can only auto-generate them for record types, found type: " + String.valueOf(type);
    }

    @Override
    public boolean supportsTypeForDeserialization(Type type) {
        Objects.requireNonNull(type, "type");
        return this.supports(type);
    }

    @Override
    public JsonDeserializer getDeserializer(Type type) throws NotRegisteredException {
        Objects.requireNonNull(type, "type");
        return (JsonDeserializer)this.get(type);
    }
}

