/*
 * Decompiled with CFR 0.152.
 */
package name.martingeisse.grumpyjson.registry;

import java.util.concurrent.atomic.AtomicBoolean;

public abstract class Sealable {
    private final AtomicBoolean sealedFlag = new AtomicBoolean(false);

    protected final void ensureConfigurationPhase() {
        if (this.sealedFlag.get()) {
            throw new IllegalStateException("this " + this.getClass().getSimpleName() + " has been sealed already");
        }
    }

    protected final void ensureRunTimePhase() {
        if (!this.sealedFlag.get()) {
            throw new IllegalStateException("this " + this.getClass().getSimpleName() + " has not yet been sealed");
        }
    }

    public final void seal() {
        this.ensureConfigurationPhase();
        this.sealedFlag.set(true);
        this.onSeal();
    }

    protected void onSeal() {
    }
}

