/*
 * Decompiled with CFR 0.152.
 */
package name.martingeisse.grumpyjson.serialize;

import com.google.gson.JsonElement;
import java.util.Objects;
import java.util.Optional;
import name.martingeisse.grumpyjson.registry.NotRegisteredException;
import name.martingeisse.grumpyjson.serialize.JsonSerializationException;
import name.martingeisse.grumpyjson.serialize.JsonSerializer;

public interface JsonSerializerProvider {
    public boolean supportsClassForSerialization(Class<?> var1);

    public <T> JsonSerializer<T> getSerializer(Class<T> var1) throws NotRegisteredException;

    default public JsonElement serialize(Object value) throws JsonSerializationException {
        JsonSerializer<?> serializer;
        Objects.requireNonNull(value, "value");
        Class<?> clazz = value.getClass();
        try {
            serializer = this.getSerializer(clazz);
        }
        catch (NotRegisteredException e) {
            throw new JsonSerializationException("no serializer for type: " + String.valueOf(clazz));
        }
        return serializer.serialize(value);
    }

    default public Optional<JsonElement> serializeOptional(Object value) throws JsonSerializationException {
        JsonSerializer<?> serializer;
        Objects.requireNonNull(value, "value");
        Class<?> clazz = value.getClass();
        try {
            serializer = this.getSerializer(clazz);
        }
        catch (NotRegisteredException e) {
            throw new JsonSerializationException("no serializer for type: " + String.valueOf(clazz));
        }
        return serializer.serializeOptional(value);
    }
}

