/*
 * Decompiled with CFR 0.152.
 */
package io.github.ibuildthecloud.gdapi.request.handler;

import io.github.ibuildthecloud.gdapi.condition.Condition;
import io.github.ibuildthecloud.gdapi.condition.ConditionType;
import io.github.ibuildthecloud.gdapi.context.ApiContext;
import io.github.ibuildthecloud.gdapi.id.IdFormatter;
import io.github.ibuildthecloud.gdapi.model.Field;
import io.github.ibuildthecloud.gdapi.model.FieldType;
import io.github.ibuildthecloud.gdapi.model.Filter;
import io.github.ibuildthecloud.gdapi.model.Include;
import io.github.ibuildthecloud.gdapi.model.Pagination;
import io.github.ibuildthecloud.gdapi.model.Schema;
import io.github.ibuildthecloud.gdapi.model.Sort;
import io.github.ibuildthecloud.gdapi.request.ApiRequest;
import io.github.ibuildthecloud.gdapi.request.handler.AbstractApiRequestHandler;
import io.github.ibuildthecloud.gdapi.util.RequestUtils;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class ParseCollectionAttributes
extends AbstractApiRequestHandler {
    Integer defaultLimit = 100;
    Integer maxLimit = 1000;

    @Override
    public void handle(ApiRequest request) throws IOException {
        if (!Schema.Method.GET.isMethod(request.getMethod())) {
            return;
        }
        Schema schema = request.getSchemaFactory().getSchema(request.getType());
        if (schema == null) {
            return;
        }
        Map<String, Object> params = RequestUtils.toMap(request.getRequestObject());
        this.parseSort(schema, params, request);
        this.parsePagination(schema, params, request);
        this.parseFilters(schema, params, request);
        this.parseIncludes(schema, params, request);
    }

    protected void parseIncludes(Schema schema, Map<String, Object> params, ApiRequest request) {
        ArrayList<String> links = new ArrayList<String>();
        List<?> inputs = RequestUtils.toList(params.get("include"));
        for (Object input : inputs) {
            links.add(input.toString());
        }
        if (links.size() > 0) {
            request.setInclude(new Include(links));
        }
    }

    protected void parseFilters(Schema schema, Map<String, Object> params, ApiRequest request) {
        IdFormatter formatter = ApiContext.getContext().getIdFormatter();
        Map<String, Filter> filters = schema.getCollectionFilters();
        Map<String, Field> fields = schema.getResourceFields();
        TreeMap<String, List<Condition>> conditions = new TreeMap<String, List<Condition>>();
        for (Map.Entry<String, Object> entry : params.entrySet()) {
            NameAndOp nameAndOp = new NameAndOp(entry.getKey());
            Filter filter = filters.get(nameAndOp.getName());
            Field field = fields.get(nameAndOp.getName());
            if (filter == null || field == null) continue;
            for (String mod : filter.getModifiers()) {
                if (!nameAndOp.getOp().equals(mod)) continue;
                ArrayList<Condition> conditionList = new ArrayList<Condition>();
                ConditionType conditionType = ConditionType.valueOf(nameAndOp.getOp().toUpperCase());
                for (Object obj : RequestUtils.toList(entry.getValue())) {
                    if (field.getTypeEnum() == FieldType.REFERENCE && (obj = formatter.parseId(obj.toString())) == null) {
                        obj = "-1";
                    }
                    conditionList.add(new Condition(conditionType, obj));
                }
                conditions.put(nameAndOp.getName(), conditionList);
            }
        }
        request.setConditions(conditions);
    }

    protected void parseSort(Schema schema, Map<String, Object> params, ApiRequest request) {
        Field field;
        Sort.SortOrder orderEnum = Sort.SortOrder.ASC;
        String sort = RequestUtils.getSingularStringValue("sort", params);
        String order = RequestUtils.getSingularStringValue("order", params);
        if (order != null) {
            try {
                orderEnum = Sort.SortOrder.valueOf(order.trim().toUpperCase());
            }
            catch (IllegalArgumentException e) {
                // empty catch block
            }
        }
        if ((field = schema.getResourceFields().get(sort)) == null || !schema.getCollectionFilters().containsKey(sort)) {
            return;
        }
        URL reverseUrl = ApiContext.getUrlBuilder().reverseSort(orderEnum);
        if (reverseUrl == null) {
            return;
        }
        request.setSort(new Sort(sort, orderEnum, reverseUrl));
    }

    protected void parsePagination(Schema schema, Map<String, Object> params, ApiRequest request) {
        String limit = RequestUtils.getSingularStringValue("limit", params);
        String marker = RequestUtils.getSingularStringValue("marker", params);
        Pagination pagination = new Pagination(this.defaultLimit == null ? this.maxLimit : this.defaultLimit);
        pagination.setMarker(marker);
        try {
            if (limit != null) {
                Integer limitInt = new Integer(limit);
                if (this.maxLimit != null && limitInt > this.maxLimit) {
                    limitInt = this.maxLimit;
                }
                pagination.setLimit(limitInt);
            }
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        request.setPagination(pagination);
    }

    public Integer getDefaultLimit() {
        return this.defaultLimit;
    }

    public void setDefaultLimit(Integer defaultLimit) {
        this.defaultLimit = defaultLimit;
    }

    public Integer getMaxLimit() {
        return this.maxLimit;
    }

    public void setMaxLimit(Integer maxLimit) {
        this.maxLimit = maxLimit;
    }

    private static final class NameAndOp {
        String name;
        String op;

        public NameAndOp(String value) {
            int idx = value.lastIndexOf("_");
            if (idx == -1) {
                this.name = value;
                this.op = ConditionType.EQ.getExternalForm();
            } else {
                this.op = value.substring(idx + 1);
                this.name = value.substring(0, idx);
            }
        }

        public String getName() {
            return this.name;
        }

        public String getOp() {
            return this.op;
        }
    }
}

