/*
 * Decompiled with CFR 0.152.
 */
package io.github.ibuildthecloud.gdapi.model.impl;

import io.github.ibuildthecloud.gdapi.id.IdFormatter;
import io.github.ibuildthecloud.gdapi.id.IdFormatterUtils;
import io.github.ibuildthecloud.gdapi.model.Field;
import io.github.ibuildthecloud.gdapi.model.FieldType;
import io.github.ibuildthecloud.gdapi.model.Resource;
import io.github.ibuildthecloud.gdapi.model.Schema;
import io.github.ibuildthecloud.gdapi.model.impl.ResourceImpl;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.xml.bind.annotation.XmlTransient;

public class WrappedResource
extends ResourceImpl
implements Resource {
    Schema schema;
    Object obj;
    Map<String, Object> fields = new TreeMap<String, Object>();
    Map<String, Object> priorityFields = new LinkedHashMap<String, Object>();
    Map<String, Object> additionalFields;
    Map<String, Field> resourceFields;
    boolean createTsFields = true;
    Set<String> priorityFieldNames = null;
    IdFormatter idFormatter;

    public WrappedResource(IdFormatter idFormatter, Schema schema, Object obj, Map<String, Object> additionalFields) {
        this(idFormatter, schema, obj, additionalFields, null);
    }

    public WrappedResource(IdFormatter idFormatter, Schema schema, Object obj, Map<String, Object> additionalFields, Set<String> priorityFieldNames) {
        this.schema = schema;
        this.resourceFields = schema.getResourceFields();
        this.obj = obj;
        this.idFormatter = idFormatter;
        this.additionalFields = additionalFields;
        this.priorityFieldNames = priorityFieldNames;
        this.init();
    }

    public WrappedResource(IdFormatter idFormatter, Schema schema, Object obj) {
        this(idFormatter, schema, obj, new HashMap<String, Object>());
    }

    protected void addField(String key, Object value) {
        if (this.priorityFieldNames != null && this.priorityFieldNames.contains(key)) {
            this.priorityFields.put(key, value);
        } else {
            this.fields.put(key, value);
        }
    }

    protected void init() {
        for (Map.Entry<String, Field> entry : this.resourceFields.entrySet()) {
            Field field;
            String name = entry.getKey();
            if (name.equals("id") || !(field = entry.getValue()).isIncludeInList()) continue;
            Object value = this.additionalFields.remove(name);
            if (value == null) {
                value = field.getValue(this.obj);
            }
            this.addField(name, IdFormatterUtils.formatReference(field, this.idFormatter, value));
            if (!this.createTsFields || field.getTypeEnum() != FieldType.DATE || !(value instanceof Date)) continue;
            this.addField(name + "TS", ((Date)value).getTime());
        }
        for (Map.Entry<String, Object> entry : this.additionalFields.entrySet()) {
            Object value = entry.getValue();
            String key = entry.getKey();
            Field field = this.resourceFields.get(key);
            if ((field == null || !field.isIncludeInList()) && !this.isResource(value)) continue;
            this.addField(key, value);
        }
        Object id = this.idFormatter.formatId(this.getType(), this.getIdValue());
        if (id != null) {
            this.setId(id.toString());
        }
    }

    protected boolean isResource(Object obj) {
        List list;
        if (obj instanceof Resource) {
            return true;
        }
        return obj instanceof List && ((list = (List)obj).size() == 0 || this.isResource(list.get(0)));
    }

    protected Object getIdValue() {
        Field idField = this.schema.getResourceFields().get("id");
        return idField == null ? null : idField.getValue(this.obj);
    }

    @Override
    public String getType() {
        return this.schema.getId();
    }

    @Override
    public Map<String, Object> getFields() {
        if (this.priorityFields.size() == 0) {
            return this.fields;
        }
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>(this.priorityFields);
        result.putAll(this.fields);
        return result;
    }

    @XmlTransient
    public boolean isCreateTsFields() {
        return this.createTsFields;
    }

    public void setCreateTsFields(boolean createTsFields) {
        this.createTsFields = createTsFields;
    }

    public Set<String> getPriorityFieldNames() {
        return this.priorityFieldNames;
    }

    @XmlTransient
    public void setPriorityFieldNames(Set<String> priorityFieldNames) {
        this.priorityFieldNames = priorityFieldNames;
    }
}

