/*
 * Decompiled with CFR 0.152.
 */
package io.github.interacto.command.library;

import io.github.interacto.command.CommandImpl;
import io.github.interacto.error.ErrorCatcher;
import java.awt.Desktop;
import java.io.IOException;
import java.net.URI;

public class OpenWebPage
extends CommandImpl {
    protected final Desktop desktop;
    protected final URI uri;
    protected boolean browsed;

    public OpenWebPage(Desktop desktop, URI uri) {
        this.desktop = desktop;
        this.uri = uri;
        this.browsed = false;
    }

    @Override
    protected void doCmdBody() {
        try {
            this.desktop.browse(this.uri);
            this.browsed = true;
        }
        catch (IOException exception) {
            ErrorCatcher.getInstance().reportError(exception);
            this.browsed = false;
        }
    }

    @Override
    public boolean canDo() {
        return this.uri != null && this.desktop != null && this.desktop.isSupported(Desktop.Action.BROWSE);
    }

    @Override
    public boolean hadEffect() {
        return this.browsed;
    }
}

