/*
 * Decompiled with CFR 0.152.
 */
package io.github.interacto.command;

public interface Command {
    public static void executeAndFlush(Command cmd) {
        if (cmd == null) {
            return;
        }
        if (cmd.canDo()) {
            cmd.doIt();
        }
        cmd.flush();
    }

    public void flush();

    public RegistrationPolicy getRegistrationPolicy();

    public boolean doIt();

    public boolean canDo();

    public boolean hadEffect();

    public boolean unregisteredBy(Command var1);

    public void done();

    public boolean isDone();

    public void cancel();

    public CmdStatus getStatus();

    public static enum CmdStatus {
        CREATED,
        EXECUTED,
        CANCELLED,
        DONE,
        FLUSHED;

    }

    public static enum RegistrationPolicy {
        NONE,
        UNLIMITED,
        LIMITED;

    }
}

